/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.managers.PunishmentManager;
import org.myplugin.deepGuardXray.punishments.AbstractPunishmentHandler;

public class MiningLicenseSuspensionHandler
extends AbstractPunishmentHandler {
    public MiningLicenseSuspensionHandler(deepGuardXray plugin, ConfigManager configManager, PunishmentManager punishmentManager) {
        super(plugin, configManager, punishmentManager);
    }

    @Override
    public boolean processBlockBreak(Player player, Block block) {
        Material ore = block.getType();
        if (!this.isValuableOre(ore)) {
            return false;
        }
        long remainingTime = this.punishmentManager.getMiningLicenseSuspensionTime(player.getUniqueId()) / 60000L;
        player.sendMessage(Component.text((String)"Your mining license for valuable ores is suspended!").color((TextColor)NamedTextColor.RED));
        player.sendMessage(Component.text((String)("Time remaining: " + remainingTime + " minutes")).color((TextColor)NamedTextColor.YELLOW));
        return true;
    }

    @Override
    public boolean isActive(Player player) {
        return this.punishmentManager.hasMiningLicenseSuspension(player.getUniqueId());
    }
}

