/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers.Paranoia.effects;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;

public class EnvironmentEffect {
    private final deepGuardXray plugin;
    private final ConfigManager configManager;

    public EnvironmentEffect(deepGuardXray plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void simulateCaveIn(Player player, Block brokenBlock) {
        World world = player.getWorld();
        Location playerLoc = player.getLocation();
        ArrayList<Block> potentialFallingBlocks = new ArrayList<Block>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 1; y <= 3; ++y) {
                    Block block = world.getBlockAt(brokenBlock.getX() + x, brokenBlock.getY() + y, brokenBlock.getZ() + z);
                    if (block.getType() != Material.STONE && block.getType() != Material.DEEPSLATE && block.getType() != Material.ANDESITE && block.getType() != Material.GRANITE && block.getType() != Material.DIORITE) continue;
                    potentialFallingBlocks.add(block);
                }
            }
        }
        if (potentialFallingBlocks.isEmpty()) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Cave-in effect cancelled for " + player.getName() + " - no suitable blocks found");
            }
            return;
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Simulating cave-in effect for " + player.getName() + " with " + Math.min(5, potentialFallingBlocks.size()) + " falling blocks");
        }
        player.playSound(playerLoc, Sound.BLOCK_GRAVEL_BREAK, 1.0f, 0.5f);
        player.playSound(playerLoc, Sound.BLOCK_STONE_BREAK, 1.0f, 0.7f);
        int fallingCount = Math.min(5, potentialFallingBlocks.size());
        for (int i = 0; i < fallingCount; ++i) {
            int index = ThreadLocalRandom.current().nextInt(potentialFallingBlocks.size());
            Block fallingBlock = (Block)potentialFallingBlocks.get(index);
            potentialFallingBlocks.remove(index);
            final FallingBlock visual = world.spawnFallingBlock(fallingBlock.getLocation().add(0.5, 0.0, 0.5), fallingBlock.getBlockData());
            visual.setDropItem(false);
            visual.setCancelDrop(true);
            visual.setMetadata("visual_only", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            new BukkitRunnable(this){

                public void run() {
                    if (visual != null && !visual.isDead()) {
                        visual.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
        world.spawnParticle(Particle.CLOUD, brokenBlock.getLocation().add(0.5, 1.5, 0.5), 30, 1.0, 1.0, 1.0, 0.1);
    }

    public void applyFakeDamage(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 1.0f);
        player.playHurtAnimation(0.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 30, 0, false, false, false));
        String[] damageSources = new String[]{"You feel something sharp slice against your back!", "Something stabs at your leg from the darkness!", "A searing pain shoots through your body!", "You feel the sting of ghostly claws!", "Something unseen strikes you from behind!", "A choking sensation tightens around your throat for a moment!"};
        player.sendMessage(String.valueOf(ChatColor.RED) + damageSources[ThreadLocalRandom.current().nextInt(damageSources.length)]);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Applied fake damage effect to " + player.getName());
        }
    }

    public void createFakeOreIllusion(final Player player, Block sourceBlock) {
        Material[] oreTypes = new Material[]{Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.ANCIENT_DEBRIS};
        final World world = player.getWorld();
        Location sourceLoc = sourceBlock.getLocation();
        ArrayList<Block> stoneBlocks = new ArrayList<Block>();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    Block block = world.getBlockAt(sourceLoc.getBlockX() + x, sourceLoc.getBlockY() + y, sourceLoc.getBlockZ() + z);
                    if (block.getType() != Material.STONE && block.getType() != Material.DEEPSLATE) continue;
                    stoneBlocks.add(block);
                }
            }
        }
        if (stoneBlocks.isEmpty()) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Fake ore illusion cancelled for " + player.getName() + " - no suitable blocks found");
            }
            return;
        }
        int illusionCount = 1 + ThreadLocalRandom.current().nextInt(3);
        illusionCount = Math.min(illusionCount, stoneBlocks.size());
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Creating fake ore illusion for " + player.getName() + " with " + illusionCount + " fake ores");
        }
        for (int i = 0; i < illusionCount; ++i) {
            int index = ThreadLocalRandom.current().nextInt(stoneBlocks.size());
            final Block targetBlock = (Block)stoneBlocks.get(index);
            stoneBlocks.remove(index);
            Material originalType = targetBlock.getType();
            Material oreType = originalType == Material.DEEPSLATE ? oreTypes[ThreadLocalRandom.current().nextInt(2) + 1] : oreTypes[ThreadLocalRandom.current().nextInt(2)];
            player.sendBlockChange(targetBlock.getLocation(), Bukkit.createBlockData((Material)oreType));
            int revertDelay = 20 + ThreadLocalRandom.current().nextInt(20);
            new BukkitRunnable(this){

                public void run() {
                    player.sendBlockChange(targetBlock.getLocation(), targetBlock.getBlockData());
                    if (ThreadLocalRandom.current().nextBoolean()) {
                        world.spawnParticle(Particle.SMOKE, targetBlock.getLocation().add(0.5, 0.5, 0.5), 8, 0.3, 0.3, 0.3, 0.02);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)revertDelay);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.2f);
    }

    public void createTeleportIllusion(final Player player) {
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Creating teleport illusion for " + player.getName());
        }
        Location originalLoc = player.getLocation();
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0, false, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 100, 0, false, false, false));
        player.playSound(originalLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.PORTAL, originalLoc.add(0.0, 1.0, 0.0), 60, 0.5, 1.0, 0.5, 0.01);
        player.setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * 0.2, 0.2, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.2));
        if (ThreadLocalRandom.current().nextBoolean()) {
            player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_AMBIENT, 0.5f, 0.7f);
        }
        new BukkitRunnable(this){

            public void run() {
                if (player.isOnline()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.7f, 1.2f);
                    player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation().add(0.0, 1.0, 0.0), 40, 0.5, 1.0, 0.5, 0.01);
                    player.setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * 0.15, 0.1, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.15));
                    if (ThreadLocalRandom.current().nextInt(100) < 70) {
                        String[] messages = new String[]{"Where am I?", "This isn't where I was...", "Something pulled me through the void...", "The darkness... it moved me...", "I can feel eyes watching me..."};
                        player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + messages[ThreadLocalRandom.current().nextInt(messages.length)]);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 25L);
        new BukkitRunnable(this){

            public void run() {
                if (player.isOnline()) {
                    player.playSound(player.getLocation(), Sound.AMBIENT_CAVE, 1.0f, 0.5f);
                    if (ThreadLocalRandom.current().nextInt(100) < 30) {
                        double angle = ThreadLocalRandom.current().nextDouble() * 2.0 * Math.PI;
                        double distance = 20.0;
                        Location soundLoc = player.getLocation().add(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
                        player.playSound(soundLoc, Sound.ENTITY_ENDERMAN_AMBIENT, 0.4f, 0.7f);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 50L);
    }

    public void createFakeExplosion(Player player) {
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Creating fake explosion effect for " + player.getName());
        }
        Location loc = player.getLocation();
        World world = loc.getWorld();
        player.playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 0.7f, 1.0f);
        world.spawnParticle(Particle.EXPLOSION, loc.add(ThreadLocalRandom.current().nextDouble(-3.0, 3.0), ThreadLocalRandom.current().nextDouble(-2.0, 2.0), ThreadLocalRandom.current().nextDouble(-3.0, 3.0)), 1, 0.0, 0.0, 0.0, 0.0);
        Vector knockback = player.getLocation().getDirection().multiply(-0.3);
        knockback.setY(0.2);
        player.setVelocity(knockback);
        player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 40, 0, false, false, false));
    }

    public void applyTripwireEffect(Player player) {
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Applied tripwire slowness effect to " + player.getName());
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 20, 2, false, false, false));
        player.playSound(player.getLocation(), Sound.BLOCK_TRIPWIRE_CLICK_ON, 0.6f, 1.2f);
        player.setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * 0.02, 0.05, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.02));
        player.getWorld().spawnParticle(Particle.CRIT, player.getLocation().add(0.0, 0.1, 0.0), 10, 0.3, 0.05, 0.3, 0.02);
    }
}

