/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers.Paranoia.effects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.util.LocationUtils;
import org.myplugin.deepGuardXray.punishments.handlers.Paranoia.util.ParanoiaDataHolder;

public class GhostEntityEffect {
    private final deepGuardXray plugin;
    private final ConfigManager configManager;
    private final ParanoiaDataHolder dataHolder;

    public GhostEntityEffect(deepGuardXray plugin, ConfigManager configManager, ParanoiaDataHolder dataHolder) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.dataHolder = dataHolder;
    }

    public void spawnGhostMob(final Player player, Location location) {
        final UUID playerId = player.getUniqueId();
        EntityType[] hostileMobs = new EntityType[]{EntityType.CREEPER, EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.ENDERMAN, EntityType.WITCH, EntityType.WARDEN};
        EntityType mobType = hostileMobs[ThreadLocalRandom.current().nextInt(hostileMobs.length)];
        Location spawnLoc = LocationUtils.findSafeLocationNearby(location);
        if (spawnLoc == null) {
            return;
        }
        final Entity ghostMob = spawnLoc.getWorld().spawnEntity(spawnLoc, mobType);
        ghostMob.setMetadata("ghost_mob", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        if (ghostMob instanceof LivingEntity) {
            Enderman enderman;
            boolean willCharge;
            LivingEntity livingMob = (LivingEntity)ghostMob;
            boolean bl = willCharge = ThreadLocalRandom.current().nextInt(100) < 40;
            if (willCharge) {
                livingMob.setAI(true);
                if (livingMob instanceof Monster) {
                    ((Monster)livingMob).setTarget((LivingEntity)player);
                }
                if (mobType == EntityType.CREEPER) {
                    Creeper creeper = (Creeper)livingMob;
                    creeper.setPowered(ThreadLocalRandom.current().nextBoolean());
                    if (ThreadLocalRandom.current().nextInt(100) < 30) {
                        player.playSound(creeper.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 1.0f, 1.0f);
                    }
                } else if (mobType == EntityType.ENDERMAN) {
                    enderman = (Enderman)livingMob;
                    enderman.setTarget((LivingEntity)player);
                } else if (mobType == EntityType.SKELETON) {
                    player.playSound(livingMob.getLocation(), Sound.ENTITY_SKELETON_SHOOT, 0.5f, 0.8f);
                }
            } else {
                livingMob.setAI(false);
                Vector direction = player.getLocation().toVector().subtract(livingMob.getLocation().toVector()).normalize();
                Location lookLocation = livingMob.getLocation().setDirection(direction);
                livingMob.teleport(lookLocation);
            }
            if (mobType == EntityType.ENDERMAN) {
                enderman = (Enderman)livingMob;
                enderman.setTarget((LivingEntity)player);
            }
        }
        this.dataHolder.addGhostEntity(playerId, ghostMob);
        player.playSound(ghostMob.getLocation(), switch (mobType.name()) {
            case "CREEPER" -> Sound.ENTITY_CREEPER_PRIMED;
            case "ZOMBIE" -> Sound.ENTITY_ZOMBIE_AMBIENT;
            case "SKELETON" -> Sound.ENTITY_SKELETON_AMBIENT;
            case "SPIDER" -> Sound.ENTITY_SPIDER_AMBIENT;
            case "ENDERMAN" -> Sound.ENTITY_ENDERMAN_STARE;
            case "WITCH" -> Sound.ENTITY_WITCH_AMBIENT;
            case "WARDEN" -> Sound.ENTITY_WARDEN_ANGRY;
            default -> Sound.ENTITY_GENERIC_EXPLODE;
        }, 0.8f, 0.7f);
        int disappearTime = 80 + ThreadLocalRandom.current().nextInt(60);
        new BukkitRunnable(this){
            final /* synthetic */ GhostEntityEffect this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!ghostMob.isDead()) {
                    ghostMob.getWorld().spawnParticle(Particle.SMOKE, ghostMob.getLocation().add(0.0, 1.0, 0.0), 30, 0.3, 0.5, 0.3, 0.05);
                    ghostMob.getWorld().spawnParticle(Particle.PORTAL, ghostMob.getLocation().add(0.0, 1.0, 0.0), 20, 0.3, 0.5, 0.3, 0.05);
                    player.playSound(ghostMob.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.7f, 0.5f);
                    ghostMob.remove();
                }
                this.this$0.dataHolder.removeGhostEntity(playerId, ghostMob);
            }
        }.runTaskLater((Plugin)this.plugin, (long)disappearTime);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Spawned ghost " + mobType.name() + " for " + player.getName());
        }
    }

    public void spawnPeripheralGhostMob(Player player) {
        Location playerLoc = player.getLocation();
        Vector playerDir = playerLoc.getDirection();
        boolean leftSide = ThreadLocalRandom.current().nextBoolean();
        double angle = Math.toRadians(90 + ThreadLocalRandom.current().nextInt(30));
        if (leftSide) {
            angle = -angle;
        }
        double x = playerDir.getX();
        double z = playerDir.getZ();
        double newX = x * Math.cos(angle) - z * Math.sin(angle);
        double newZ = x * Math.sin(angle) + z * Math.cos(angle);
        Vector direction = new Vector(newX, 0.0, newZ).normalize();
        double distance = 8.0 + ThreadLocalRandom.current().nextDouble() * 4.0;
        Location spawnLoc = playerLoc.clone().add(direction.multiply(distance));
        spawnLoc.setY(playerLoc.getY());
        spawnLoc = LocationUtils.findSafeLocationNearby(spawnLoc);
        if (spawnLoc == null) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Peripheral ghost mob cancelled for " + player.getName() + " - no valid location found");
            }
            return;
        }
        EntityType[] hostileMobs = new EntityType[]{EntityType.CREEPER, EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.ENDERMAN};
        EntityType mobType = hostileMobs[ThreadLocalRandom.current().nextInt(hostileMobs.length)];
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Spawning peripheral ghost " + mobType.name() + " for " + player.getName() + " at distance " + player.getLocation().distance(spawnLoc));
        }
        final Entity ghostMob = spawnLoc.getWorld().spawnEntity(spawnLoc, mobType);
        ghostMob.setMetadata("ghost_mob", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        final UUID playerId = player.getUniqueId();
        this.dataHolder.addGhostEntity(playerId, ghostMob);
        if (ghostMob instanceof LivingEntity) {
            LivingEntity livingMob = (LivingEntity)ghostMob;
            livingMob.setAI(false);
            if (mobType == EntityType.ENDERMAN) {
                Enderman enderman = (Enderman)livingMob;
                enderman.setTarget((LivingEntity)player);
            }
        }
        int disappearTime = 40 + ThreadLocalRandom.current().nextInt(40);
        new BukkitRunnable(this){
            final /* synthetic */ GhostEntityEffect this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!ghostMob.isDead() && ghostMob.isValid()) {
                    ghostMob.getWorld().spawnParticle(Particle.SMOKE, ghostMob.getLocation().add(0.0, 1.0, 0.0), 30, 0.3, 0.5, 0.3, 0.05);
                    ghostMob.remove();
                }
                this.this$0.dataHolder.removeGhostEntity(playerId, ghostMob);
            }
        }.runTaskLater((Plugin)this.plugin, (long)disappearTime);
    }

    public void createFakePlayerSighting(final Player player) {
        Location playerLoc = player.getLocation();
        Vector direction = playerLoc.getDirection().normalize();
        direction.add(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * 0.3, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.1, (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.3)).normalize();
        double distance = 15.0 + ThreadLocalRandom.current().nextDouble() * 10.0;
        Location spawnLoc = playerLoc.clone().add(direction.multiply(distance));
        spawnLoc = LocationUtils.findSafeLocationNearby(spawnLoc);
        if (spawnLoc == null) {
            if (this.configManager.isDebugEnabled()) {
                this.plugin.getLogger().info("Fake player sighting cancelled for " + player.getName() + " - no valid location found");
            }
            return;
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Creating fake player sighting for " + player.getName() + " at distance " + Math.round(player.getLocation().distance(spawnLoc)));
        }
        final ArmorStand stand = (ArmorStand)spawnLoc.getWorld().spawnEntity(spawnLoc, EntityType.ARMOR_STAND);
        stand.setVisible(false);
        final UUID playerId = player.getUniqueId();
        this.dataHolder.addGhostEntity(playerId, (Entity)stand);
        for (int i = 0; i < 3; ++i) {
            new BukkitRunnable(this){

                public void run() {
                    if (player.isOnline() && !stand.isDead()) {
                        player.playSound(stand.getLocation(), Sound.BLOCK_STONE_HIT, 0.4f, 1.0f);
                        player.getWorld().spawnParticle(Particle.BLOCK_CRUMBLE, stand.getLocation().add(0.0, 1.0, 0.0), 10, 0.2, 0.2, 0.2, 0.05, (Object)Bukkit.createBlockData((Material)Material.STONE));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)i * 10L);
        }
        new BukkitRunnable(this){
            final /* synthetic */ GhostEntityEffect this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!stand.isDead()) {
                    stand.remove();
                }
                this.this$0.dataHolder.removeGhostEntity(playerId, (Entity)stand);
            }
        }.runTaskLater((Plugin)this.plugin, 40L);
    }

    public void trackAndUpdateGhostMobs() {
        int totalEntities = 0;
        int facingUpdates = 0;
        int pathUpdates = 0;
        HashMap<EntityType, Integer> entityTypeStats = new HashMap<EntityType, Integer>();
        for (List<Entity> entities : this.dataHolder.getAllGhostEntities().values()) {
            totalEntities += entities.size();
        }
        if (totalEntities == 0) {
            return;
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("trackAndUpdateGhostMobs running - tracking " + totalEntities + " ghost entities for " + this.dataHolder.getAllGhostEntities().size() + " players");
        }
        int updatedEntities = 0;
        int activatedEntities = 0;
        for (final UUID playerId : new ArrayList<UUID>(this.dataHolder.getAllGhostEntities().keySet())) {
            final Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) {
                if (!this.configManager.isDebugEnabled()) continue;
                this.plugin.getLogger().info("Skipping ghost update for offline player UUID: " + String.valueOf(playerId));
                continue;
            }
            List<Entity> playerEntities = this.dataHolder.getPlayerGhostEntities(playerId);
            if (this.configManager.isDebugEnabled() && !playerEntities.isEmpty()) {
                this.plugin.getLogger().info("Processing " + playerEntities.size() + " ghost entities for player " + player.getName());
            }
            for (final Entity entity : new ArrayList<Entity>(playerEntities)) {
                if (entity == null || entity.isDead()) {
                    this.dataHolder.removeGhostEntity(playerId, entity);
                    continue;
                }
                if (this.configManager.isDebugEnabled()) {
                    entityTypeStats.put(entity.getType(), entityTypeStats.getOrDefault(entity.getType(), 0) + 1);
                }
                if (!ThreadLocalRandom.current().nextBoolean()) continue;
                ++updatedEntities;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.hasAI()) {
                    if (!(livingEntity instanceof Monster)) continue;
                    ((Monster)livingEntity).setTarget((LivingEntity)player);
                    ++pathUpdates;
                    if (!this.configManager.isDebugEnabled()) continue;
                    this.plugin.getLogger().info("Updated target path for " + String.valueOf(entity.getType()) + " ghost entity chasing " + player.getName() + ", distance: " + String.format("%.1f", entity.getLocation().distance(player.getLocation())));
                    continue;
                }
                Vector direction = player.getLocation().toVector().subtract(entity.getLocation().toVector()).normalize();
                Location lookLoc = entity.getLocation().setDirection(direction);
                entity.teleport(lookLoc);
                ++facingUpdates;
                if (this.configManager.isDebugEnabled() && ThreadLocalRandom.current().nextInt(5) == 0) {
                    this.plugin.getLogger().info("Updated facing direction for " + String.valueOf(entity.getType()) + " ghost entity to look at " + player.getName());
                }
                if (ThreadLocalRandom.current().nextInt(100) >= 10 || !(entity instanceof Monster) || livingEntity.hasAI()) continue;
                livingEntity.setAI(true);
                ((Monster)livingEntity).setTarget((LivingEntity)player);
                ++activatedEntities;
                if (this.configManager.isDebugEnabled()) {
                    this.plugin.getLogger().info("\u2605 JUMP-SCARE: Activated " + String.valueOf(entity.getType()) + " ghost entity to charge at " + player.getName() + " from distance " + String.format("%.1f", entity.getLocation().distance(player.getLocation())));
                }
                if (entity instanceof Creeper) {
                    player.playSound(entity.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 1.0f, 1.0f);
                } else if (entity instanceof Zombie) {
                    player.playSound(entity.getLocation(), Sound.ENTITY_ZOMBIE_AMBIENT, 1.0f, 0.7f);
                } else {
                    player.playSound(entity.getLocation(), Sound.ENTITY_HOSTILE_HURT, 0.8f, 0.6f);
                }
                new BukkitRunnable(this){
                    final /* synthetic */ GhostEntityEffect this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        if (!entity.isDead()) {
                            if (this.this$0.configManager.isDebugEnabled()) {
                                this.this$0.plugin.getLogger().info("Removing charging " + String.valueOf(entity.getType()) + " ghost entity after jump-scare for " + player.getName());
                            }
                            entity.getWorld().spawnParticle(Particle.SMOKE, entity.getLocation().add(0.0, 1.0, 0.0), 30, 0.3, 0.5, 0.3, 0.05);
                            entity.getWorld().spawnParticle(Particle.PORTAL, entity.getLocation().add(0.0, 1.0, 0.0), 20, 0.3, 0.5, 0.3, 0.05);
                            entity.remove();
                            this.this$0.dataHolder.removeGhostEntity(playerId, entity);
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 40L);
            }
        }
        this.dataHolder.removeDeadEntities();
        if (this.configManager.isDebugEnabled() && (updatedEntities > 0 || activatedEntities > 0)) {
            StringBuilder statsLog = new StringBuilder();
            statsLog.append("Ghost tracking stats: ");
            statsLog.append(updatedEntities).append(" entities updated (");
            statsLog.append(pathUpdates).append(" paths, ");
            statsLog.append(facingUpdates).append(" facings), ");
            statsLog.append(activatedEntities).append(" jump-scares activated");
            if (!entityTypeStats.isEmpty()) {
                statsLog.append(" - Types: ");
                for (Map.Entry entry : entityTypeStats.entrySet()) {
                    statsLog.append(((EntityType)entry.getKey()).name()).append("(").append(entry.getValue()).append(") ");
                }
            }
            this.plugin.getLogger().info(statsLog.toString());
        }
    }

    public void cleanup() {
        int removedEntities = 0;
        this.dataHolder.cleanupAllGhostEntities();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.hasMetadata("nightmare_ghost") && !entity.hasMetadata("ghost_mob")) continue;
                entity.remove();
                ++removedEntities;
            }
        }
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("GhostEntityEffect cleanup: removed " + removedEntities + " remaining entities");
        }
    }
}

