/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers.Paranoia.effects;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.myplugin.deepGuardXray.config.ConfigManager;
import org.myplugin.deepGuardXray.deepGuardXray;

public class SoundEffect {
    private final deepGuardXray plugin;
    private final ConfigManager configManager;
    private final Sound[] scarySounds = new Sound[]{Sound.ENTITY_CREEPER_PRIMED, Sound.ENTITY_ENDERMAN_SCREAM, Sound.ENTITY_GHAST_WARN, Sound.ENTITY_WITHER_AMBIENT, Sound.ENTITY_ZOMBIE_AMBIENT, Sound.ENTITY_SKELETON_AMBIENT, Sound.ENTITY_SPIDER_AMBIENT, Sound.AMBIENT_CAVE, Sound.BLOCK_STONE_BREAK, Sound.ENTITY_TNT_PRIMED, Sound.BLOCK_CHORUS_FLOWER_DEATH, Sound.ENTITY_WARDEN_NEARBY_CLOSER, Sound.ENTITY_WARDEN_HEARTBEAT};

    public SoundEffect(deepGuardXray plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void playParanoiaSound(Player player) {
        Location soundLoc;
        Sound sound = this.scarySounds[ThreadLocalRandom.current().nextInt(this.scarySounds.length)];
        Location playerLoc = player.getLocation();
        if (ThreadLocalRandom.current().nextBoolean()) {
            double distance = 3.0 + ThreadLocalRandom.current().nextDouble() * 7.0;
            double angle = ThreadLocalRandom.current().nextDouble() * 2.0 * Math.PI;
            double x = playerLoc.getX() + Math.cos(angle) * distance;
            double z = playerLoc.getZ() + Math.sin(angle) * distance;
            soundLoc = new Location(playerLoc.getWorld(), x, playerLoc.getY(), z);
        } else {
            soundLoc = playerLoc;
        }
        float volume = 0.3f + ThreadLocalRandom.current().nextFloat() * 0.7f;
        float pitch = 0.7f + ThreadLocalRandom.current().nextFloat() * 0.6f;
        player.playSound(soundLoc, sound, volume, pitch);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Playing paranoia sound " + String.valueOf(sound) + " to " + player.getName());
        }
    }

    public void playDistantMiningSound(final Player player) {
        Location playerLoc = player.getLocation();
        double distance = 15.0 + ThreadLocalRandom.current().nextDouble() * 10.0;
        double angle = ThreadLocalRandom.current().nextDouble() * 2.0 * Math.PI;
        double x = playerLoc.getX() + Math.cos(angle) * distance;
        double z = playerLoc.getZ() + Math.sin(angle) * distance;
        final Location soundLoc = new Location(playerLoc.getWorld(), x, playerLoc.getY(), z);
        if (this.configManager.isDebugEnabled()) {
            this.plugin.getLogger().info("Playing distant mining sounds for " + player.getName() + " at " + Math.round(distance) + " blocks away");
        }
        Sound[] miningSounds = new Sound[]{Sound.BLOCK_STONE_BREAK, Sound.BLOCK_STONE_HIT};
        int soundCount = 2 + ThreadLocalRandom.current().nextInt(3);
        for (int i = 0; i < soundCount; ++i) {
            final Sound sound = miningSounds[ThreadLocalRandom.current().nextInt(miningSounds.length)];
            new BukkitRunnable(this){

                public void run() {
                    if (player.isOnline()) {
                        player.playSound(soundLoc, sound, 0.4f, 0.8f + ThreadLocalRandom.current().nextFloat() * 0.4f);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)i * 10L);
        }
    }
}

