/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.punishments.handlers.Paranoia.util;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LocationUtils {
    public static Location findSafeLocationNearby(Location baseLoc) {
        if (LocationUtils.isSafeLocation(baseLoc)) {
            return baseLoc;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            double offsetX = ThreadLocalRandom.current().nextDouble(-3.0, 3.0);
            double offsetY = ThreadLocalRandom.current().nextDouble(-2.0, 2.0);
            double offsetZ = ThreadLocalRandom.current().nextDouble(-3.0, 3.0);
            Location testLoc = baseLoc.clone().add(offsetX, offsetY, offsetZ);
            if (!LocationUtils.isSafeLocation(testLoc)) continue;
            return testLoc;
        }
        return null;
    }

    public static boolean isSafeLocation(Location loc) {
        Block block = loc.getBlock();
        Block above = block.getRelative(0, 1, 0);
        Block below = block.getRelative(0, -1, 0);
        return block.getType() == Material.AIR && above.getType() == Material.AIR && below.getType().isSolid();
    }

    public static Location getRandomNearbyLocation(Location base, double radius) {
        double x = base.getX() + (ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0 * radius;
        double y = base.getY() + (ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0 * radius;
        double z = base.getZ() + (ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0 * radius;
        return new Location(base.getWorld(), x, y, z);
    }

    public static Location findValidSpawnLocationInSight(Location playerLoc, World world, double minDistance, double maxDistance) {
        for (int attempt = 0; attempt < 12; ++attempt) {
            double angle = (double)attempt * 0.5235987755982988;
            for (double distance = minDistance; distance <= maxDistance; distance += 2.0) {
                double x = playerLoc.getX() + Math.cos(angle) * distance;
                double z = playerLoc.getZ() + Math.sin(angle) * distance;
                for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                    Location testLoc = new Location(world, x, playerLoc.getY() + (double)yOffset, z);
                    if (!LocationUtils.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
        }
        return null;
    }

    public static class LocationHolder {
        public Location location;
    }
}

