/*
 * Decompiled with CFR 0.152.
 */
package org.myplugin.deepGuardXray.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateApplier {
    private final JavaPlugin plugin;
    private final Logger logger;
    private boolean updatePending = false;
    private File currentPluginFile = null;

    public UpdateApplier(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public boolean checkForPendingUpdate() {
        File pluginsDirectory = this.plugin.getServer().getUpdateFolderFile().getParentFile();
        this.logger.info("Server plugins directory: " + pluginsDirectory.getAbsolutePath());
        File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
        if (!updateMarker.exists()) {
            return false;
        }
        try {
            File newPluginFile;
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(updateMarker);){
                props.load(fis);
            }
            String version = props.getProperty("version");
            String currentPluginPath = props.getProperty("current_plugin");
            String newPluginPath = props.getProperty("new_plugin");
            boolean alreadyDeleted = Boolean.parseBoolean(props.getProperty("already_deleted", "false"));
            if (version == null || currentPluginPath == null || newPluginPath == null) {
                this.logger.warning("Invalid update marker file. Missing required properties.");
                return false;
            }
            if (!alreadyDeleted) {
                this.currentPluginFile = new File(currentPluginPath);
                if (!this.currentPluginFile.exists()) {
                    this.logger.info("Old plugin file already removed, no cleanup needed.");
                    alreadyDeleted = true;
                }
            }
            if (!(newPluginFile = new File(newPluginPath)).exists()) {
                this.logger.warning("New plugin file does not exist: " + newPluginPath);
                updateMarker.delete();
                return false;
            }
            this.updatePending = true;
            this.logger.info("=================================================");
            this.logger.info(" DeepGuard-XRay: Update ready to use!");
            this.logger.info(" Current version: " + this.plugin.getDescription().getVersion());
            this.logger.info(" New version: " + version);
            this.logger.info(" Old plugin will be removed during server shutdown.");
            this.logger.info("=================================================");
            return true;
        }
        catch (Exception e) {
            this.logger.severe("Failed to check for pending update: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void applyUpdateOnShutdown() {
        if (!this.updatePending) {
            return;
        }
        if (this.currentPluginFile == null) {
            File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
            if (updateMarker.exists()) {
                updateMarker.delete();
                this.logger.info("Update complete, removed marker file.");
            }
            return;
        }
        try {
            this.logger.info("=================================================");
            this.logger.info(" DeepGuard-XRay: Cleaning up old plugin file");
            File updateMarker = new File(this.plugin.getDataFolder(), "pending_update.txt");
            if (updateMarker.exists()) {
                updateMarker.delete();
                this.logger.info(" Removed update marker file");
            }
            if (this.currentPluginFile.exists()) {
                this.currentPluginFile.deleteOnExit();
                this.logger.info(" Old plugin file will be deleted when the server fully stops");
            }
            File pluginDataFolder = this.plugin.getDataFolder();
            File cleanupMarker = new File(pluginDataFolder, "cleanup_marker.txt");
            try (FileWriter writer = new FileWriter(cleanupMarker);){
                writer.write("path=" + this.currentPluginFile.getAbsolutePath() + "\n");
                writer.write("timestamp=" + System.currentTimeMillis() + "\n");
            }
            this.logger.info(" Created cleanup marker for next server start");
            this.logger.info("=================================================");
        }
        catch (Exception e) {
            this.logger.severe("Failed during update cleanup: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isUpdatePending() {
        return this.updatePending;
    }

    public void performPendingCleanup() {
        File cleanupMarker = new File(this.plugin.getDataFolder(), "cleanup_marker.txt");
        if (!cleanupMarker.exists()) {
            return;
        }
        try {
            File fileToDelete;
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(cleanupMarker);){
                props.load(fis);
            }
            String filePath = props.getProperty("path");
            if (filePath != null && (fileToDelete = new File(filePath)).exists()) {
                boolean deleted = fileToDelete.delete();
                this.logger.info("Cleanup of old plugin file " + (deleted ? "successful" : "failed") + ": " + filePath);
            }
            cleanupMarker.delete();
        }
        catch (Exception e) {
            this.logger.warning("Error during cleanup: " + e.getMessage());
        }
    }
}

