/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.client.gui.components.sliders.HudOffsetSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.HudScaleSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class SeasonOptionsScreen
extends SeasonHudScreen {
    private static final Component SCREEN_TITLE = Common.translatedText("menu.seasonhud.season.title");
    private Location hudLocation;
    private int xSliderInt;
    private int ySliderInt;
    private double seasonScale;
    private ShowDay showDay;
    private boolean seasonColor;
    private boolean showSubSeason;
    private boolean showTropicalSeason;
    private boolean showFertility;
    private boolean needCalendar;
    private boolean enableCalendarDetail;
    private boolean drawDefaultHud;
    private int dayLength;
    private int newDayLength;
    private CycleButton<Location> hudLocationButton;
    private HudOffsetSlider xSlider;
    private HudOffsetSlider ySlider;
    private HudScaleSlider hudScaleSlider;
    private EditBox dayLengthBox;

    public SeasonOptionsScreen(Screen parentScreen) {
        super(parentScreen, SCREEN_TITLE);
    }

    public static SeasonOptionsScreen getInstance(Screen parentScreen) {
        return new SeasonOptionsScreen(parentScreen);
    }

    public void loadConfig() {
        this.drawDefaultHud = Common.drawDefaultHudMenu();
        this.hudLocation = SeasonHudClient.getHudLocation();
        this.xSliderInt = SeasonHudClient.getHudX();
        this.ySliderInt = SeasonHudClient.getHudY();
        this.seasonScale = SeasonHudClient.getHudScale();
        this.showDay = SeasonHudClient.getShowDay();
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
        this.showSubSeason = SeasonHudClient.getShowSubSeason();
        this.showTropicalSeason = SeasonHudClient.getShowTropicalSeason();
        if (Common.hasCalendarLoaded()) {
            this.needCalendar = SeasonHudServer.getNeedCalendar();
            this.enableCalendarDetail = SeasonHudServer.getCalendarDetailMode();
        }
        if (Common.fabricSeasonsLoaded()) {
            this.dayLength = SeasonHudServer.getDayLength();
        }
        if (Common.sereneSeasonsLoaded()) {
            this.showFertility = SeasonHudClient.getShowFertility();
        }
    }

    @Override
    public void saveConfig() {
        if (this.drawDefaultHud) {
            SeasonHudClient.setHudLocation((Location)((Object)this.hudLocationButton.getValue()));
            SeasonHudClient.setHudX(this.xSlider.getValueInt());
            SeasonHudClient.setHudY(this.ySlider.getValueInt());
            SeasonHudClient.setHudScale(this.hudScaleSlider.getValueDouble());
        }
        SeasonHudClient.setShowDay(this.showDay);
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        if (Common.hasSubSeasons()) {
            SeasonHudClient.setShowSubSeason(this.showSubSeason);
            SeasonHudClient.setShowTropicalSeason(this.showTropicalSeason);
        }
        if (Common.clientSideConfig()) {
            if (Common.hasCalendarLoaded()) {
                SeasonHudServer.setCalendarDetailMode(this.enableCalendarDetail);
                SeasonHudServer.setNeedCalendar(this.needCalendar);
            }
            if (Common.fabricSeasonsLoaded()) {
                SeasonHudServer.setDayLength(Integer.parseInt(this.dayLengthBox.getValue()));
            }
            SeasonHudServer.SERVER_SPEC.save();
        }
        if (Common.sereneSeasonsLoaded()) {
            SeasonHudClient.setShowFertility(this.showFertility);
        }
        SeasonHudClient.CLIENT_SPEC.save();
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void onClose() {
        super.onClose();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int x = 3;
        int y = 3;
        this.seasonScale = 1.0;
        MutableComponent seasonCombined = CurrentSeason.getInstance(this.minecraft).getConfigText(this.showDay, this.showSubSeason, this.seasonColor);
        MutableComponent fertility = CurrentFertility.getInstance(this.minecraft).getHudText();
        if (this.drawDefaultHud) {
            int DEFAULT_X_OFFSET_SCALED = 2;
            int DEFAULT_Y_OFFSET_SCALED = 2;
            this.seasonScale = this.hudScaleSlider.getValueDouble();
            int componentWidth = (int)((double)this.font.width((FormattedText)seasonCombined) * this.seasonScale);
            Objects.requireNonNull(this.font);
            int componentHeight = (int)(9.0 * this.seasonScale);
            boolean customLocation = this.hudLocationButton.getValue() == Location.CUSTOM;
            this.hudScaleSlider.visible = this.drawDefaultHud;
            this.xSlider.active = customLocation;
            this.xSlider.visible = this.drawDefaultHud;
            this.ySlider.active = customLocation;
            this.ySlider.visible = this.drawDefaultHud;
            switch (this.hudLocation) {
                case TOP_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_CENTER: {
                    x = (int)(((double)this.width / 2.0 - (double)componentWidth / 2.0) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_RIGHT: {
                    x = (int)((double)(this.width - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = (int)((double)(this.height - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = (int)((double)(this.width - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = (int)((double)(this.height - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case CUSTOM: {
                    x = this.xSlider.getValueInt();
                    y = this.ySlider.getValueInt();
                }
            }
        }
        if (Common.fabricSeasonsLoaded() && Common.clientSideConfig()) {
            int row = 4;
            if (Common.fabricSeasonsExtrasLoaded()) {
                ++row;
            }
            if (!this.drawDefaultHud) {
                row -= 2;
            }
            int n = this.leftButtonX + this.BUTTON_WIDTH / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, "Day Length", n, 50 + row * (this.BUTTON_HEIGHT + 6) - (9 + 6), 0xFFFFFF);
        }
        graphics.pose().pushMatrix();
        graphics.pose().translate(0.0f, 0.0f);
        graphics.pose().scale((float)this.seasonScale, (float)this.seasonScale);
        graphics.drawString(this.font, (Component)seasonCombined, x, y, -1);
        if (this.showFertility) {
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, (Component)fertility, x, y += 9, 0xFFFFFF);
        }
        graphics.pose().popMatrix();
    }

    private int maxWidth(MutableComponent seasonText) {
        int textWidth = this.font.width((FormattedText)seasonText);
        return (int)(((double)this.width - (double)textWidth * this.seasonScale) / this.seasonScale);
    }

    private int maxHeight() {
        Objects.requireNonNull(this.font);
        int textHeight = 9;
        return (int)(((double)this.height - (double)textHeight * this.seasonScale) / this.seasonScale);
    }

    @Override
    public void init() {
        this.loadConfig();
        super.init();
        MutableComponent seasonCombined = CurrentSeason.getInstance(this.minecraft).getHudText();
        this.row = -1;
        if (this.drawDefaultHud) {
            ++this.row;
            this.hudLocationButton = CycleButton.builder(Location::getLocationName).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.hudLocation.tooltip")).withValues((Object[])Location.values()).withInitialValue((Object)this.hudLocation).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.hudLocation.button"), (b, val) -> {
                this.hudLocation = val;
            });
            this.hudScaleSlider = HudScaleSlider.builder((Component)Common.translatedText("menu.seasonhud.season.scale.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.scale.tooltip")).withValueRange(0.5, 10.0).withInitialValue(this.seasonScale).withDefaultValue(1.0).withStepSize(0.5).withPrecision(1).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT).build();
            ++this.row;
            this.xSlider = HudOffsetSlider.builder((Component)Common.translatedText("menu.seasonhud.season.xOffset.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.xOffset.tooltip")).withValues(0, this.maxWidth(seasonCombined), this.xSliderInt, 2).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.ySlider = HudOffsetSlider.builder((Component)Common.translatedText("menu.seasonhud.season.yOffset.slider")).withTooltip(Common.newTooltip("menu.seasonhud.season.yOffset.tooltip")).withValues(0, this.maxHeight(), this.ySliderInt, 2).withBounds(this.rightButtonX + this.BUTTON_WIDTH / 2 + 2, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.widgets.addAll(Arrays.asList(new AbstractWidget[]{this.hudLocationButton, this.hudScaleSlider, this.xSlider, this.ySlider}));
        }
        ++this.row;
        CycleButton showDayButton = CycleButton.builder(ShowDay::getDayDisplayName).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showDay.tooltip")).withValues(ShowDay.getValues()).withInitialValue((Object)this.showDay).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showDay.button"), (b, val) -> {
            this.showDay = val;
        });
        CycleButton seasonColorButton = CycleButton.onOffBuilder((boolean)this.seasonColor).withTooltip(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            this.seasonColor = val;
        });
        this.widgets.addAll(Arrays.asList(showDayButton, seasonColorButton));
        if (Common.hasSubSeasons()) {
            ++this.row;
            CycleButton showSubSeasonButton = CycleButton.onOffBuilder((boolean)this.showSubSeason).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showSubSeason.tooltip")).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showSubSeason.button"), (b, val) -> {
                this.showSubSeason = val;
            });
            CycleButton showTropicalSeasonButton = CycleButton.onOffBuilder((boolean)this.showTropicalSeason).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showTropicalSeason.tooltip")).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showTropicalSeason.button"), (b, val) -> {
                this.showTropicalSeason = val;
            });
            this.widgets.addAll(Arrays.asList(showSubSeasonButton, showTropicalSeasonButton));
        }
        if (Common.hasCalendarLoaded()) {
            ++this.row;
            CycleButton needCalendarButton = CycleButton.onOffBuilder((boolean)this.needCalendar).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.needCalendar.tooltip")).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.needCalendar.button"), (b, val) -> {
                this.needCalendar = val;
            });
            needCalendarButton.active = Common.clientSideConfig();
            CycleButton calendarDetailModeButton = CycleButton.onOffBuilder((boolean)this.enableCalendarDetail).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.calendarDetail.tooltip")).create(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.calendarDetail.button"), (b, val) -> {
                this.enableCalendarDetail = val;
            });
            if (!Common.clientSideConfig()) {
                needCalendarButton.active = false;
                needCalendarButton.setTooltip(Common.newTooltip("menu.seasonhud.season.serverSide.tooltip"));
                calendarDetailModeButton.active = false;
                calendarDetailModeButton.setTooltip(Common.newTooltip("menu.seasonhud.season.serverSide.tooltip"));
            }
            this.widgets.addAll(Arrays.asList(needCalendarButton, calendarDetailModeButton));
        }
        if (Common.sereneSeasonsLoaded()) {
            ++this.row;
            CycleButton showFertilityButton = CycleButton.onOffBuilder((boolean)this.showFertility).withTooltip(t -> Common.newTooltip("menu.seasonhud.season.showFertility.tooltip")).create(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showFertility.button"), (b, val) -> {
                this.showFertility = val;
            });
            this.widgets.add(showFertilityButton);
        }
        if (Common.fabricSeasonsLoaded()) {
            this.row += 2;
            this.dayLengthBox = new EditBox(this.font, this.leftButtonX + 1, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH - 2, this.BUTTON_HEIGHT, (Component)Common.literalText(String.valueOf(this.dayLength)));
            this.dayLengthBox.setMaxLength(10);
            this.dayLengthBox.setValue(String.valueOf(this.dayLength));
            this.dayLengthBox.setResponder(lengthString -> {
                if (this.validate((String)lengthString)) {
                    this.dayLengthBox.setTextColor(-1);
                    int currentLength = Integer.parseInt(lengthString);
                    if (currentLength != this.newDayLength) {
                        this.newDayLength = currentLength;
                        this.dayLengthBox.setValue(lengthString);
                    }
                    SeasonOptionsScreen.doneButton.active = true;
                } else {
                    this.dayLengthBox.setTextColor(0xFF5555);
                    SeasonOptionsScreen.doneButton.active = false;
                }
            });
            this.dayLengthBox.setHint((Component)Common.literalText("" + this.dayLength).withStyle(ChatFormatting.DARK_GRAY));
            this.dayLengthBox.visible = Common.clientSideConfig();
            this.widgets.add(this.dayLengthBox);
        }
        this.widgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private boolean inBounds(int length) {
        int minInt = 0;
        return length >= minInt;
    }

    public boolean validate(String length) {
        try {
            int dayLength = Integer.parseInt(length);
            return this.inBounds(dayLength);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }
}

