/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.joml.Matrix3x2fStack;

public class MapAtlasesCommon {
    private MapAtlasesCommon() {
    }

    private static void drawSeasonWithLighterShadow(GuiGraphics graphics, Font font, MutableComponent text, MutableComponent shadowText) {
        graphics.drawString(font, (Component)shadowText, 1, 1, 0x595959, false);
        graphics.drawString(font, (Component)text, 0, 0, -1, false);
    }

    private static void drawScaledComponent(GuiGraphics graphics, Font font, int x, int y, MutableComponent text, MutableComponent shadowText, float textScaling, int maxWidth, int targetWidth) {
        Matrix3x2fStack pose = graphics.pose();
        float textWidth = font.width((FormattedText)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        scale *= textScaling;
        float centerX = (float)x + (float)targetWidth / 2.0f;
        pose.pushMatrix();
        pose.translate(centerX, (float)(y + 4));
        pose.scale(scale, scale);
        pose.translate(-textWidth / 2.0f, -4.0f);
        MapAtlasesCommon.drawSeasonWithLighterShadow(graphics, font, text, shadowText);
        pose.popMatrix();
    }

    public static void drawMapComponentSeason(GuiGraphics graphics, Font font, int x, int y, int targetWidth, float textScaling, float globalScale) {
        MutableComponent seasonCombined = CurrentSeason.getInstance(Minecraft.getInstance()).getHudText();
        MutableComponent seasonShadowText = CurrentSeason.getInstance(Minecraft.getInstance()).getHudTextNoFormat();
        MutableComponent fertility = CurrentFertility.getInstance(Minecraft.getInstance()).getMinimapText();
        MutableComponent fertilityShadowText = CurrentFertility.getInstance(Minecraft.getInstance()).getHudTextNoFormat();
        MapAtlasesCommon.drawScaledComponent(graphics, font, x, y, seasonCombined, seasonShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
            Objects.requireNonNull(font);
            MapAtlasesCommon.drawScaledComponent(graphics, font, x, y + 9, fertility, fertilityShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        }
    }

    public static void drawScaledText(GuiGraphics context, int x, int y, MutableComponent text, MutableComponent shadowText, float textScaling, int originOffsetWidth, int originOffsetHeight) {
        Minecraft mc = Minecraft.getInstance();
        Matrix3x2fStack poseStack = context.pose();
        float textWidth = (float)mc.font.width((FormattedText)text) * textScaling;
        float textX = (float)((double)x + (double)originOffsetWidth / 2.0 - (double)textWidth / 2.0);
        float textY = y + originOffsetHeight;
        if (textX + textWidth >= (float)mc.getWindow().getGuiScaledWidth()) {
            textX = (float)mc.getWindow().getGuiScaledWidth() - textWidth;
        }
        poseStack.pushMatrix();
        poseStack.translate(textX, textY);
        poseStack.scale(textScaling, textScaling);
        context.drawString(mc.font, (Component)shadowText, 1, 1, Integer.parseInt("595959", 16), false);
        context.drawString(mc.font, (Component)text, 0, 0, Integer.parseInt("E0E0E0", 16), false);
        poseStack.popMatrix();
    }

    public static void drawMapComponentSeasonOld(GuiGraphics poseStack, int x, int y, int originOffsetWidth, int originOffsetHeight, float textScaling) {
        if (CurrentMinimap.mapAtlasesLoaded()) {
            Minecraft mc = Minecraft.getInstance();
            MutableComponent seasonCombined = CurrentSeason.getInstance(Minecraft.getInstance()).getHudText();
            MutableComponent seasonShadowText = CurrentSeason.getInstance(Minecraft.getInstance()).getHudTextNoFormat();
            MutableComponent fertility = CurrentFertility.getInstance(Minecraft.getInstance()).getMinimapText();
            MutableComponent fertilityShadowText = CurrentFertility.getInstance(Minecraft.getInstance()).getHudTextNoFormat();
            MapAtlasesCommon.drawScaledText(poseStack, x, y, seasonCombined, seasonShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
                Objects.requireNonNull(mc.font);
                MapAtlasesCommon.drawScaledText(poseStack, x, y + 9, fertility, fertilityShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            }
        }
    }
}

