/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class SeasonHudCommon {
    public static final ModConfigSpec GENERAL_SPEC;
    static ModConfigSpec.BooleanValue needCalendar;
    static ModConfigSpec.ConfigValue<Integer> dayLength;

    private SeasonHudCommon() {
    }

    private static void setupConfig(ModConfigSpec.Builder builder) {
        builder.push("Season");
        needCalendar = builder.comment("Require the calendar item to be in the players inventory to show the HUD?\n(true/false)\nDefault is false.").define("need_calendar", false);
        dayLength = builder.comment("Change if you are using a Minecraft day length other than vanilla value and using Fabric Seasons.\nDefault Minecraft day is 24000.").defineInRange("day_length", 24000, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static boolean getNeedCalendar() {
        return (Boolean)needCalendar.get();
    }

    public static void setNeedCalendar(boolean enable) {
        needCalendar.set((Object)enable);
    }

    public static int getDayLength() {
        return (Integer)dayLength.get();
    }

    public static void setDayLength(int length) {
        dayLength.set((Object)length);
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        SeasonHudCommon.setupConfig(builder);
        GENERAL_SPEC = builder.build();
    }
}

