/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class MapAtlasesCommon {
    private MapAtlasesCommon() {
    }

    private static void drawSeasonWithLighterShadow(PoseStack graphics, Font font, MutableComponent text, MutableComponent shadowText) {
        font.m_92889_(graphics, (Component)shadowText, 1.0f, 1.0f, 0x595959);
        font.m_92889_(graphics, (Component)text, 0.0f, 0.0f, 0xFFFFFF);
    }

    private static void drawScaledComponent(PoseStack graphics, Font font, int x, int y, MutableComponent text, MutableComponent shadowText, float textScaling, int maxWidth, int targetWidth) {
        float textWidth = font.m_92852_((FormattedText)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        graphics.m_85836_();
        graphics.m_85837_((double)centerX, (double)(y + 4), 5.0);
        graphics.m_85841_(scale *= textScaling, scale, 1.0f);
        graphics.m_85837_((double)(-textWidth / 2.0f), -4.0, 0.0);
        MapAtlasesCommon.drawSeasonWithLighterShadow(graphics, font, text, shadowText);
        graphics.m_85849_();
    }

    public static void drawMapComponentSeason(PoseStack graphics, Font font, int x, int y, int targetWidth, float textScaling, float globalScale) {
        MutableComponent seasonCombined = CurrentSeason.getInstance(Minecraft.m_91087_()).getSeasonHudText();
        MutableComponent shadowText = CurrentSeason.getInstance(Minecraft.m_91087_()).getSeasonHudTextNoFormat();
        MapAtlasesCommon.drawScaledComponent(graphics, font, x, y, seasonCombined, shadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
    }

    public static void drawScaledText(PoseStack graphics, int x, int y, MutableComponent text, MutableComponent shadowText, float textScaling, int originOffsetWidth, int originOffsetHeight) {
        Minecraft mc = Minecraft.m_91087_();
        float textWidth = (float)mc.f_91062_.m_92852_((FormattedText)text) * textScaling;
        float textX = (float)((double)x + (double)originOffsetWidth / 2.0 - (double)textWidth / 2.0);
        float textY = y + originOffsetHeight;
        if (textX + textWidth >= (float)mc.m_91268_().m_85445_()) {
            textX = (float)mc.m_91268_().m_85445_() - textWidth;
        }
        graphics.m_85836_();
        graphics.m_85837_((double)textX, (double)textY, 5.0);
        graphics.m_85841_(textScaling, textScaling, 1.0f);
        mc.f_91062_.m_92889_(graphics, (Component)shadowText, 1.0f, 1.0f, Integer.parseInt("595959", 16));
        mc.f_91062_.m_92889_(graphics, (Component)text, 0.0f, 0.0f, Integer.parseInt("E0E0E0", 16));
        graphics.m_85849_();
    }

    public static void drawMapComponentSeasonOld(PoseStack graphics, int x, int y, int originOffsetWidth, int originOffsetHeight, float textScaling) {
        if (CurrentMinimap.mapAtlasesLoaded()) {
            MutableComponent seasonCombined = CurrentSeason.getInstance(Minecraft.m_91087_()).getSeasonHudText();
            MutableComponent shadowText = CurrentSeason.getInstance(Minecraft.m_91087_()).getSeasonHudTextNoFormat();
            MapAtlasesCommon.drawScaledText(graphics, x, y, seasonCombined, shadowText, textScaling, originOffsetWidth, originOffsetHeight);
        }
    }
}

