/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.boxes;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.jetbrains.annotations.NotNull;

public class ColorEditBox
extends TextFieldWidget {
    private static final int PADDING = 4;
    private final Seasons boxSeason;
    private final int seasonColor;
    private int newSeasonColor;

    public ColorEditBox(FontRenderer font, int x, int y, int width, int height, Seasons season) {
        super(font, x, y, width, height, season.getSeasonName());
        this.boxSeason = season;
        this.newSeasonColor = this.seasonColor = season.getSeasonColor();
        this.func_146203_f(8);
        this.func_146180_a(String.valueOf(this.seasonColor));
        this.func_212954_a(colorString -> {
            if (this.validate((String)colorString)) {
                this.func_146193_g(0xFFFFFF);
                int colorInt = Integer.parseInt(colorString);
                if (colorInt != this.newSeasonColor) {
                    this.newSeasonColor = colorInt;
                    this.func_146180_a((String)colorString);
                }
                ColorScreen.doneButton.field_230693_o_ = true;
            } else {
                this.func_146193_g(0xFF5555);
                ColorScreen.doneButton.field_230693_o_ = false;
            }
        });
        this.func_146184_c(SeasonHudClient.getEnableSeasonNameColor());
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }

    public void save() {
        Rgb.setRgb(this.boxSeason, this.newSeasonColor);
        this.boxSeason.setSeasonColor(this.newSeasonColor);
    }

    public int getColor() {
        return this.seasonColor;
    }

    public int getNewColor() {
        return this.newSeasonColor;
    }

    public Seasons getSeason() {
        return this.boxSeason;
    }

    public void func_230430_a_(@NotNull MatrixStack graphics, int mouseX, int mouseY, float partialTicks) {
        int widgetTotalSize;
        Minecraft mc = Minecraft.func_71410_x();
        float textScale = 1.0f;
        int scaledWidth = mc.func_228018_at_().func_198107_o();
        boolean seasonShort = scaledWidth < (widgetTotalSize = 86 * ColorEditBox.seasonListSet().size());
        IFormattableTextComponent seasonCombined = CurrentSeason.getInstance(mc).getSeasonMenuText(this.boxSeason, Color.func_240743_a_((int)this.newSeasonColor), seasonShort);
        graphics.func_227860_a_();
        if (mc.field_71466_p.func_238414_a_((ITextProperties)seasonCombined) > this.func_230998_h_() - 4) {
            textScale = ((float)this.func_230998_h_() - 4.0f) / (float)mc.field_71466_p.func_238414_a_((ITextProperties)seasonCombined);
        }
        graphics.func_227862_a_(textScale, textScale, 1.0f);
        FontRenderer fontRenderer = mc.field_71466_p;
        int n = (int)(((double)this.field_230690_l_ + (double)this.func_230998_h_() / 2.0) / (double)textScale);
        float f = this.field_230691_m_;
        Objects.requireNonNull(mc.field_71466_p);
        ColorEditBox.func_238472_a_((MatrixStack)graphics, (FontRenderer)fontRenderer, (ITextComponent)seasonCombined, (int)n, (int)((int)((f - 9.0f * textScale - 4.0f) / textScale)), (int)0xFFFFFF);
        graphics.func_227865_b_();
        super.func_230430_a_(graphics, mouseX, mouseY, partialTicks);
    }
}

