/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IBidiTooltip;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class CycleButton<T>
extends AbstractButton
implements IBidiTooltip {
    static final BooleanSupplier DEFAULT_ALT_LIST_SELECTOR = Screen::func_231174_t_;
    private static final List<Boolean> BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private final ITextComponent name;
    private final ValueListSupplier<T> values;
    private final Function<T, ITextComponent> valueStringifier;
    private final OnValueChange<T> onValueChange;
    private final TooltipSupplier<T> tooltipSupplier;
    private final boolean displayOnlyValue;
    private int index;
    private T value;

    CycleButton(int i, int j, int k, int l, ITextComponent component, ITextComponent component2, int m, T object, ValueListSupplier<T> valueListSupplier, Function<T, ITextComponent> function, OnValueChange<T> onValueChange, TooltipSupplier<T> tooltipSupplier, boolean bl) {
        super(i, j, k, l, component);
        this.name = component2;
        this.index = m;
        this.value = object;
        this.values = valueListSupplier;
        this.valueStringifier = function;
        this.onValueChange = onValueChange;
        this.tooltipSupplier = tooltipSupplier;
        this.displayOnlyValue = bl;
    }

    public static IFormattableTextComponent optionNameValue(ITextComponent component, ITextComponent component2) {
        return new TranslationTextComponent("options.generic_value", new Object[]{component, component2});
    }

    public static <T> Builder<T> builder(Function<T, ITextComponent> function) {
        return new Builder<T>(function);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Object>(boolean_ -> (Boolean)boolean_ != false ? DialogTexts.field_240630_a_ : DialogTexts.field_240631_b_).withValues(BOOLEAN_OPTIONS);
    }

    public static Builder<Boolean> onOffBuilder(boolean bl) {
        return CycleButton.onOffBuilder().withInitialValue(bl);
    }

    public void func_230930_b_() {
        if (Screen.func_231173_s_()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int i) {
        List<T> list = this.values.getSelectedList();
        this.index = MathHelper.func_180184_b((int)(this.index + i), (int)list.size());
        T object = list.get(this.index);
        this.updateValue(object);
        this.onValueChange.onValueChange(this, object);
    }

    private T getCycledValue(int i) {
        List<T> list = this.values.getSelectedList();
        return list.get(MathHelper.func_180184_b((int)(this.index + i), (int)list.size()));
    }

    public boolean func_231043_a_(double d, double e, double f) {
        if (f > 0.0) {
            this.cycleValue(-1);
        } else if (f < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    private void updateValue(T object) {
        ITextComponent component = this.createLabelForValue(object);
        this.func_238482_a_(component);
        this.value = object;
    }

    private ITextComponent createLabelForValue(T object) {
        return this.displayOnlyValue ? this.valueStringifier.apply(object) : this.createFullName(object);
    }

    private IFormattableTextComponent createFullName(T object) {
        return CycleButton.optionNameValue(this.name, this.valueStringifier.apply(object));
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T object) {
        List<T> list = this.values.getSelectedList();
        int i = list.indexOf(object);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(object);
    }

    public Optional<List<IReorderingProcessor>> func_241867_d() {
        return Optional.empty();
    }

    private static interface ValueListSupplier<T> {
        public static <T> ValueListSupplier<T> create(List<T> list) {
            ImmutableList list2 = ImmutableList.copyOf(list);
            return new ValueListSupplier<T>((List)list2){
                final /* synthetic */ List val$list2;
                {
                    this.val$list2 = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list2;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list2;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier booleanSupplier, List<T> list, List<T> list2) {
            ImmutableList list3 = ImmutableList.copyOf(list);
            ImmutableList list4 = ImmutableList.copyOf(list2);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list4;
                final /* synthetic */ List val$list3;
                {
                    this.val$list4 = list;
                    this.val$list3 = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return booleanSupplier.getAsBoolean() ? this.val$list4 : this.val$list3;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list3;
                }
            };
        }

        public List<T> getSelectedList();

        public List<T> getDefaultList();
    }

    public static interface OnValueChange<T> {
        public void onValueChange(CycleButton var1, T var2);
    }

    public static interface TooltipSupplier<T>
    extends Function<T, List<IReorderingProcessor>> {
    }

    public static class Builder<T> {
        private final Function<T, ITextComponent> valueStringifier;
        private int initialIndex;
        @Nullable
        private T initialValue;
        private TooltipSupplier<T> tooltipSupplier = object -> ImmutableList.of();
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());
        private boolean displayOnlyValue;

        public Builder(Function<T, ITextComponent> function) {
            this.valueStringifier = function;
        }

        public Builder<T> withValues(List<T> list) {
            this.values = ValueListSupplier.create(list);
            return this;
        }

        public final Builder<T> withValues(T ... objects) {
            return this.withValues((List<T>)ImmutableList.copyOf((Object[])objects));
        }

        public Builder<T> withValues(List<T> list, List<T> list2) {
            this.values = ValueListSupplier.create(DEFAULT_ALT_LIST_SELECTOR, list, list2);
            return this;
        }

        public Builder<T> withValues(BooleanSupplier booleanSupplier, List<T> list, List<T> list2) {
            this.values = ValueListSupplier.create(booleanSupplier, list, list2);
            return this;
        }

        public Builder<T> withTooltip(TooltipSupplier<T> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<T> withInitialValue(T object) {
            this.initialValue = object;
            int i = this.values.getDefaultList().indexOf(object);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> displayOnlyValue() {
            this.displayOnlyValue = true;
            return this;
        }

        public CycleButton<T> create(int i, int j, int k, int l, ITextComponent component) {
            return this.create(i, j, k, l, component, (cycleButton, object) -> {});
        }

        public CycleButton<T> create(int i, int j, int k, int l, ITextComponent component, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            ITextComponent component2 = this.valueStringifier.apply(object);
            ITextComponent component3 = this.displayOnlyValue ? component2 : CycleButton.optionNameValue(component, component2);
            return new CycleButton<T>(i, j, k, l, component3, component, this.initialIndex, object, this.values, this.valueStringifier, onValueChange, this.tooltipSupplier, this.displayOnlyValue);
        }
    }
}

