/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.util.DrawUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class BasicSlider
extends AbstractSlider {
    public static final int SLIDER_PADDING = 2;
    protected static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("seasonhud:textures/gui/slider.png");
    protected boolean drawString;
    protected boolean canChangeValue;
    protected double minValue;
    protected double maxValue;
    protected double defaultValue;
    protected double stepSize;
    protected TextFormatting textColor;
    private DecimalFormat format;

    private BasicSlider(int x, int y, int width, int height, boolean drawString, double initial) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""), 0.0);
        this.drawString = drawString;
        this.field_230683_b_ = this.snapToNearest(initial);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision, TextFormatting textColor) {
        this(x, y, width, height, drawString, initial);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.field_230683_b_ = this.snapToNearest((initial - minValue) / (maxValue - minValue));
        this.stepSize = Math.abs(stepSize);
        this.textColor = textColor;
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = MathHelper.func_219806_b((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, TextFormatting textColor) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, textColor);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, stepSize, precision, TextFormatting.WHITE);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, TextFormatting.WHITE);
    }

    protected static void renderScrollingString(MatrixStack graphics, FontRenderer font, ITextComponent component, int i, int j, int k, int l, int m, int n) {
        int o = font.func_238414_a_((ITextProperties)component);
        int var10000 = k + m;
        Objects.requireNonNull(font);
        int p = (var10000 - 9) / 2 + 1;
        int q = l - j;
        if (o > q) {
            int r = o - q;
            double d = (double)Util.func_211177_b() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = MathHelper.func_219803_d((double)f, (double)0.0, (double)r);
            DrawUtil.enableScissor(j, k, l, m);
            AbstractGui.func_238475_b_((MatrixStack)graphics, (FontRenderer)font, (ITextComponent)component, (int)(j - (int)g), (int)p, (int)n);
            DrawUtil.disableScissor();
        } else {
            int r = MathHelper.func_76125_a((int)i, (int)(j + o / 2), (int)(l - o / 2));
            AbstractGui.func_238472_a_((MatrixStack)graphics, (FontRenderer)font, (ITextComponent)component, (int)r, (int)p, (int)n);
        }
    }

    protected static void renderScrollingString(MatrixStack graphics, FontRenderer font, ITextComponent component, int i, int j, int k, int l, int m) {
        BasicSlider.renderScrollingString(graphics, font, component, (i + k) / 2, i, j, k, l, m);
    }

    public void onRightClick() {
        this.setValue(this.defaultValue);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean rightClicked;
        if (this.field_230693_o_ && this.field_230694_p_ && mouseButton == 1 && (rightClicked = this.func_230992_c_(mouseX, mouseY))) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.onRightClick();
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public int getTextureY() {
        int i = this.func_230999_j_() && !this.canChangeValue ? 1 : 0;
        return i * 20;
    }

    public int getHandleTextureY() {
        int i = !this.field_230692_n_ && !this.canChangeValue ? 2 : 3;
        return i * 20;
    }

    public int getFGColor() {
        return this.field_230693_o_ ? 0xFFFFFF : 0xA0A0A0;
    }

    public double map(double d, double e, double f, double g, double h) {
        return MathHelper.func_219803_d((double)MathHelper.func_233020_c_((double)d, (double)e, (double)f), (double)g, (double)h);
    }

    protected double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0);
        }
        value = MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? MathHelper.func_151237_a((double)value, (double)this.maxValue, (double)this.minValue) : MathHelper.func_151237_a((double)value, (double)this.minValue, (double)this.maxValue);
        return this.map(value, this.minValue, this.maxValue, 0.0, 1.0);
    }

    public double getValue() {
        return this.field_230683_b_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.field_230683_b_ = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.func_230979_b_();
    }

    public double getValueDouble() {
        return (double)Math.round(this.getValue() * 10.0) / 10.0;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setSliderValue(double value) {
        double oldValue = this.field_230683_b_;
        this.field_230683_b_ = this.snapToNearest(value);
        if (!MathHelper.func_219806_b((double)oldValue, (double)this.field_230683_b_)) {
            this.func_230972_a_();
        }
        this.func_230979_b_();
    }

    protected void func_230972_a_() {
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        super.func_230983_a_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                bl = !bl;
            }
            float f2 = f = bl ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_230683_b_ + (double)(f / (float)(this.field_230688_j_ - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    protected void func_230979_b_() {
        if (this.drawString) {
            this.func_238482_a_((ITextComponent)Common.literalText(this.getValueString()));
        } else {
            this.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }
    }

    protected void renderScrollingString(MatrixStack graphics, FontRenderer font, int i, int j) {
        int k = this.field_230690_l_ + i;
        int l = this.field_230690_l_ + this.func_230998_h_() - i;
        BasicSlider.renderScrollingString(graphics, font, this.func_230458_i_(), k, this.field_230691_m_, l, this.field_230691_m_ + this.func_238483_d_(), j);
    }

    protected void func_230441_a_(@NotNull MatrixStack graphics, @NotNull Minecraft mc, int mouseX, int mouseY) {
        DrawUtil.blitWithBorder(graphics, (AbstractGui)this, SLIDER_LOCATION, this.field_230690_l_, this.field_230691_m_, 0, this.getTextureY(), this.field_230688_j_, this.field_230689_k_, 200, 20, 2, 3, 2, 2);
        DrawUtil.blitWithBorder(graphics, (AbstractGui)this, SLIDER_LOCATION, this.field_230690_l_ + (int)(this.field_230683_b_ * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, this.getHandleTextureY(), 8, this.field_230689_k_, 200, 20, 2, 3, 2, 2);
        this.renderScrollingString(graphics, mc.field_71466_p, 2, this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
    }
}

