/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders.rgb;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class RgbSlider
extends BasicSlider {
    public static final int SLIDER_PADDING = 2;
    protected final Seasons season;
    private final boolean enableColor = SeasonHudClient.getEnableSeasonNameColor();
    protected ColorEditBox seasonBox;
    protected int r;
    protected int g;
    protected int b;
    protected int rgb;

    public RgbSlider(int x, int y, int initial, ColorEditBox seasonBox, TextFormatting textColor) {
        super(x, y, seasonBox.func_230998_h_() + 2, seasonBox.func_238483_d_() - 6, true, initial, 0.0, 255.0, seasonBox.getSeason().getDefaultColor(), textColor);
        this.seasonBox = seasonBox;
        this.season = seasonBox.getSeason();
        this.rgb = Integer.parseInt(seasonBox.func_146179_b());
        this.r = Rgb.rColor(this.rgb);
        this.g = Rgb.gColor(this.rgb);
        this.b = Rgb.bColor(this.rgb);
        this.func_230979_b_();
    }

    @Override
    public void func_230982_a_(double x, double y) {
        if (this.enableColor) {
            super.func_230982_a_(x, y);
        }
    }

    @Override
    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.enableColor) {
            super.func_230983_a_(mouseX, mouseY, dragX, dragY);
        }
    }

    @Override
    public void func_230441_a_(@NotNull MatrixStack graphics, Minecraft mc, int mouseX, int mouseY) {
        if (!this.enableColor) {
            this.field_230693_o_ = false;
            this.field_230692_n_ = false;
        }
        super.func_230441_a_(graphics, mc, mouseX, mouseY);
    }

    public void setValue(int newValue) {
        double oldValue = this.field_230683_b_;
        this.field_230683_b_ = this.snapToNearest(((double)newValue - this.minValue) / (this.maxValue - this.minValue));
        if (!MathHelper.func_219806_b((double)oldValue, (double)this.field_230683_b_)) {
            this.func_230972_a_();
        }
        this.func_230979_b_();
    }

    @Override
    protected void func_230979_b_() {
        IFormattableTextComponent colorString = Common.literalText(this.getValueString());
        this.func_238482_a_((ITextComponent)colorString.func_230532_e_().func_240699_a_(this.textColor));
        if (!this.enableColor) {
            this.func_238482_a_((ITextComponent)colorString.func_230532_e_().func_240699_a_(TextFormatting.GRAY));
        }
    }
}

