/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class SeasonHUDOverlayCommon {
    private SeasonHUDOverlayCommon() {
    }

    public static void render(MatrixStack graphics) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Common.drawDefaultHud() && Common.vanillaShouldDrawHud() && Calendar.validNeedCalendar() && !Common.hideHudInCurrentDimension()) {
            int screenWidth = mc.func_228018_at_().func_198107_o();
            int screenHeight = mc.func_228018_at_().func_198087_p();
            int x = 0;
            int y = 0;
            int xOffset = SeasonHudClient.getHudX();
            int yOffset = SeasonHudClient.getHudY();
            double scale = SeasonHudClient.getHudScale();
            int DEFAULT_X_OFFSET = 2;
            int DEFAULT_Y_OFFSET = 2;
            IFormattableTextComponent seasonCombined = CurrentSeason.getInstance(mc).getSeasonHudText();
            int stringWidth = (int)((double)mc.field_71466_p.func_238414_a_((ITextProperties)seasonCombined) * scale);
            Objects.requireNonNull(mc.field_71466_p);
            int stringHeight = (int)(9.0 * scale);
            switch (SeasonHudClient.getHudLocation()) {
                case TOP_LEFT: {
                    x += DEFAULT_X_OFFSET;
                    y += DEFAULT_Y_OFFSET;
                    break;
                }
                case TOP_CENTER: {
                    x += (int)(((double)screenWidth / 2.0 - (double)stringWidth / 2.0) / scale);
                    y += DEFAULT_Y_OFFSET;
                    break;
                }
                case TOP_RIGHT: {
                    x += (int)((double)(screenWidth - stringWidth - DEFAULT_X_OFFSET) / scale);
                    y += DEFAULT_Y_OFFSET;
                    break;
                }
                case BOTTOM_LEFT: {
                    x += DEFAULT_X_OFFSET;
                    y += (int)((double)(screenHeight - stringHeight - DEFAULT_Y_OFFSET) / scale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x += (int)((double)(screenWidth - stringWidth - DEFAULT_X_OFFSET) / scale);
                    y += (int)((double)(screenHeight - stringHeight - DEFAULT_Y_OFFSET) / scale);
                    break;
                }
                case CUSTOM: {
                    x = xOffset;
                    y = yOffset;
                }
            }
            graphics.func_227860_a_();
            graphics.func_227862_a_((float)scale, (float)scale, 1.0f);
            mc.field_71466_p.func_243246_a(graphics, (ITextComponent)seasonCombined, (float)x, (float)y, 0xFFFFFF);
            graphics.func_227865_b_();
        }
    }
}

