/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.forge.platform;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.platform.services.IPlatformHelper;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import top.theillusivec4.curios.api.CuriosApi;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public String getModVersion(String modId) {
        Optional mod = ModList.get().getModContainerById(modId);
        if (mod.isPresent()) {
            return ((ModContainer)mod.get()).getModInfo().getVersion().toString();
        }
        return "Not Loaded";
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean curiosFound(PlayerEntity player, Item item) {
        boolean curioEquipped = false;
        if (Common.curiosLoaded() && !Common.accessoriesLoaded()) {
            List findCalendar = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, item.getItem());
            curioEquipped = !findCalendar.isEmpty();
        }
        return curioEquipped;
    }

    @Override
    public String getCurrentSereneSeason(PlayerEntity player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((World)player.field_70170_p);
        return currentSeasonState.getSeason().toString();
    }

    @Override
    public String getCurrentSereneSubSeason(PlayerEntity player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((World)player.field_70170_p);
        return currentSeasonState.getSubSeason().toString();
    }

    @Override
    public long getSereneSeasonDate(PlayerEntity player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((World)player.field_70170_p);
        long seasonDay = currentSeasonState.getDay();
        long subSeasonDuration = ((Integer)SeasonsConfig.subSeasonDuration.get()).intValue();
        long subSeasonDate = seasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 3L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            return subSeasonDate;
        }
        return seasonDate;
    }

    @Override
    public String getCurrentEclipticSeason(PlayerEntity player) {
        Season currentSeason = EclipticUtil.INSTANCE.getSolarTerm(player.field_70170_p).getSeason();
        return currentSeason.toString();
    }

    @Override
    public String getCurrentEclipticSubSeason(PlayerEntity player) {
        Season currentSeason = EclipticUtil.INSTANCE.getSolarTerm(player.field_70170_p).getSeason();
        return currentSeason.toString();
    }

    @Override
    public long getEclipticSeasonDate(PlayerEntity player) {
        long seasonDay = EclipticUtil.getNowSolarDay((World)player.field_70170_p);
        long subSeasonDay = EclipticUtil.getTimeInSolarTerm((World)player.field_70170_p);
        long subSeasonDuration = ((Integer)CommonConfig.Season.lastingDaysOfEachTerm.get()).intValue();
        long subSeasonDate = subSeasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 6L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            return subSeasonDate;
        }
        return seasonDate;
    }
}

