/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CommonSeasonHelper;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import java.time.LocalDateTime;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;

public class CurrentSeason {
    private final String currentSeason;
    private final String currentSubSeason;
    private final String seasonFileName;
    private final long seasonDate;
    private final int seasonDuration;
    private final PlayerEntity player;
    private Style seasonFormat;

    public CurrentSeason(Minecraft mc) {
        this.player = mc.field_71439_g;
        this.seasonFormat = Style.field_240709_b_;
        this.currentSeason = CommonSeasonHelper.commonSeasons.getCurrentSeason(this.player);
        this.currentSubSeason = CommonSeasonHelper.commonSeasons.getCurrentSubSeason(this.player);
        this.seasonFileName = CommonSeasonHelper.commonSeasons.getSeasonFileName(this.player);
        this.seasonDate = CommonSeasonHelper.commonSeasons.getDate(this.player);
        this.seasonDuration = CommonSeasonHelper.commonSeasons.seasonDuration(this.player);
    }

    public static CurrentSeason getInstance(Minecraft mc) {
        return new CurrentSeason(mc);
    }

    public String getSubSeasonLowerCase() {
        String lowerSubSeason = this.currentSubSeason.toLowerCase();
        if (Common.fabricSeasonsLoaded()) {
            return this.currentSeason.toLowerCase();
        }
        return this.currentSeason.toLowerCase() + "." + lowerSubSeason.substring(0, lowerSubSeason.indexOf("_"));
    }

    public String getSeasonLowerCase() {
        return this.currentSeason.toLowerCase();
    }

    public ITextComponent getSeasonKey(boolean showSubSeason) {
        String season;
        String string = season = showSubSeason ? this.getSubSeasonLowerCase() : this.getSeasonLowerCase();
        if (!Calendar.validDetailedMode() || Common.fabricSeasonsLoaded()) {
            season = this.getSeasonLowerCase();
        }
        if (Common.eclipticSeasonsLoaded() && Calendar.validDetailedMode() && SeasonHudClient.getShowSubSeason()) {
            season = this.currentSubSeason;
            if (this.currentSubSeason.equals("MID_NULL")) {
                return Common.translatedText("desc.seasonhud.season." + this.getSubSeasonLowerCase());
            }
            return Common.translatedText("info.eclipticseasons.environment.solar_term." + season);
        }
        return Common.translatedText("desc.seasonhud.season." + season);
    }

    public String getSeasonIcon() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getIconChar();
        }
        return "Icon Error";
    }

    public ITextComponent getText(ShowDay showDay, boolean showSubSeason) {
        IFormattableTextComponent text = Common.literalText("");
        ITextComponent seasonKey = this.getSeasonKey(showSubSeason);
        switch (showDay) {
            case NONE: {
                text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                break;
            }
            case SHOW_DAY: {
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
                break;
            }
            case SHOW_WITH_TOTAL_DAYS: {
                text = Common.translatedText(ShowDay.SHOW_WITH_TOTAL_DAYS.getKey(), seasonKey, this.seasonDate, this.seasonDuration);
                break;
            }
            case SHOW_WITH_MONTH: {
                if (CommonSeasonHelper.commonSeasons.isSeasonTiedWithSystemTime()) {
                    int systemMonth = LocalDateTime.now().getMonth().getValue();
                    String systemMonthString = String.valueOf(systemMonth);
                    if (systemMonth < 10) {
                        systemMonthString = "0" + systemMonthString;
                    }
                    IFormattableTextComponent currentMonth = Common.translatedText("desc.seasonhud.month." + systemMonthString);
                    text = Common.translatedText(ShowDay.SHOW_WITH_MONTH.getKey(), seasonKey, currentMonth, this.seasonDate);
                    if (Calendar.validDetailedMode()) break;
                    text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                    break;
                }
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
            }
        }
        return text;
    }

    public Color getTextColor() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return Color.func_240743_a_((int)season.getSeasonColor());
        }
        return Color.func_240743_a_((int)0xFFFFFF);
    }

    public IFormattableTextComponent getSeasonHudTextNoFormat() {
        IFormattableTextComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon()).func_240703_c_(Common.SEASON_ICON_STYLE);
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        IFormattableTextComponent seasonText = this.getText(showDay, showSubSeason).func_230532_e_();
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText);
    }

    public IFormattableTextComponent getSeasonHudText() {
        IFormattableTextComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon());
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        IFormattableTextComponent seasonText = this.getText(showDay, showSubSeason).func_230532_e_();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.field_240709_b_.func_240718_a_(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.func_240703_c_(Common.SEASON_ICON_STYLE), seasonText.func_240703_c_(this.seasonFormat));
    }

    public IFormattableTextComponent getSeasonMenuText(Seasons season, Color newRgb, boolean seasonShort) {
        IFormattableTextComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", season.getIconChar());
        IFormattableTextComponent seasonText = Common.translatedText(ShowDay.NONE.getKey(), season.getSeasonName());
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.field_240709_b_.func_240718_a_(newRgb);
        }
        if (season == Seasons.DRY && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.dry.editbox");
        }
        if (season == Seasons.WET && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.wet.editbox");
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.func_240703_c_(Common.SEASON_ICON_STYLE), seasonText.func_240703_c_(this.seasonFormat));
    }

    public IFormattableTextComponent getSeasonHudConfigText(ShowDay showDay, boolean showSubSeason) {
        IFormattableTextComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon());
        IFormattableTextComponent seasonText = this.getText(showDay, showSubSeason).func_230532_e_();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.field_240709_b_.func_240718_a_(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.func_240703_c_(Common.SEASON_ICON_STYLE), seasonText.func_240703_c_(this.seasonFormat));
    }
}

