/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.mods.IModHelper;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import java.time.LocalDateTime;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class FabricSeasonsHelper
implements IModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.fabricSeasonsLoaded()) {
            return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("seasons", "season_calendar"));
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        if (Common.fabricSeasonsLoaded()) {
            return FabricSeasons.CONFIG.isSeasonTiedWithSystemTime();
        }
        return false;
    }

    @Override
    public String getCurrentSubSeason(PlayerEntity player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((World)player.field_70170_p);
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public String getCurrentSeason(PlayerEntity player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((World)player.field_70170_p);
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public long getDate(PlayerEntity player) {
        long dayLength = SeasonHudServer.getDayLength();
        long seasonLength = FabricSeasons.CONFIG.getSeasonLength();
        long worldTime = player.field_70170_p.func_72820_D();
        if (this.isSeasonTiedWithSystemTime()) {
            return LocalDateTime.now().getDayOfMonth();
        }
        return (worldTime - worldTime / seasonLength * seasonLength) % seasonLength / dayLength + 1L;
    }

    @Override
    public int seasonDuration(PlayerEntity player) {
        int dayLength = SeasonHudServer.getDayLength();
        return FabricSeasons.CONFIG.getSeasonLength() / dayLength;
    }
}

