/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.mods.IModHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;

public class TerrafirmaCraftHelper
implements IModHelper {
    private List<Month> getSeasonMonths(Season season) {
        ArrayList<Month> SEASON = new ArrayList<Month>();
        switch (season) {
            case WINTER: {
                SEASON.add(SubSeason.EARLY.getWinter());
                SEASON.add(SubSeason.MID.getWinter());
                SEASON.add(SubSeason.LATE.getWinter());
                break;
            }
            case SPRING: {
                SEASON.add(SubSeason.EARLY.getSpring());
                SEASON.add(SubSeason.MID.getSpring());
                SEASON.add(SubSeason.LATE.getSpring());
                break;
            }
            case SUMMER: {
                SEASON.add(SubSeason.EARLY.getSummer());
                SEASON.add(SubSeason.MID.getSummer());
                SEASON.add(SubSeason.LATE.getSummer());
                break;
            }
            case FALL: {
                SEASON.add(SubSeason.EARLY.getAutumn());
                SEASON.add(SubSeason.MID.getAutumn());
                SEASON.add(SubSeason.LATE.getAutumn());
            }
        }
        return SEASON;
    }

    private String getSeasonPrefix(Month currentMonth) {
        Season season = currentMonth.getSeason();
        HashMap<Month, String> SEASON = new HashMap<Month, String>();
        switch (season) {
            case WINTER: {
                SEASON.put(SubSeason.EARLY.getWinter(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getWinter(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getWinter(), SubSeason.LATE.getPrefix());
                break;
            }
            case SPRING: {
                SEASON.put(SubSeason.EARLY.getSpring(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getSpring(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getSpring(), SubSeason.LATE.getPrefix());
                break;
            }
            case SUMMER: {
                SEASON.put(SubSeason.EARLY.getSummer(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getSummer(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getSummer(), SubSeason.LATE.getPrefix());
                break;
            }
            case FALL: {
                SEASON.put(SubSeason.EARLY.getAutumn(), SubSeason.EARLY.getPrefix());
                SEASON.put(SubSeason.MID.getAutumn(), SubSeason.MID.getPrefix());
                SEASON.put(SubSeason.LATE.getAutumn(), SubSeason.LATE.getPrefix());
            }
        }
        return (String)SEASON.get(currentMonth);
    }

    @Override
    public Item CALENDAR() {
        return null;
    }

    @Override
    public boolean isTropicalSeason(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(PlayerEntity player) {
        Month month = Calendars.CLIENT.getCalendarMonthOfYear();
        Season season = month.getSeason();
        String prefix = this.getSeasonPrefix(month);
        if (season == Season.FALL) {
            return prefix + "AUTUMN";
        }
        return prefix + season.func_176610_l();
    }

    @Override
    public String getCurrentSeason(PlayerEntity player) {
        Month month = Calendars.CLIENT.getCalendarMonthOfYear();
        Season season = month.getSeason();
        if (season == Season.FALL) {
            return "AUTUMN";
        }
        return Calendars.CLIENT.getCalendarMonthOfYear().getSeason().func_176610_l();
    }

    @Override
    public long getDate(PlayerEntity player) {
        Month currentMonth = Calendars.CLIENT.getCalendarMonthOfYear();
        Season currentSeason = currentMonth.getSeason();
        List<Month> currentSeasonMonths = this.getSeasonMonths(currentSeason);
        int subSeasonPos = currentSeasonMonths.indexOf(currentMonth);
        int dayOfMonth = Calendars.CLIENT.getCalendarDayOfMonth();
        int daysInMonth = Calendars.CLIENT.getCalendarDaysInMonth();
        if (SeasonHudClient.getShowSubSeason()) {
            return dayOfMonth;
        }
        return (long)dayOfMonth + (long)subSeasonPos * (long)daysInMonth;
    }

    @Override
    public int seasonDuration(PlayerEntity player) {
        int daysInMonth = Calendars.CLIENT.getCalendarDaysInMonth();
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            return daysInMonth;
        }
        return daysInMonth * 3;
    }

    private static enum SubSeason {
        EARLY("EARLY_", Month.DECEMBER, Month.MARCH, Month.JUNE, Month.SEPTEMBER),
        MID("MID_", Month.JANUARY, Month.APRIL, Month.JULY, Month.OCTOBER),
        LATE("LATE_", Month.FEBRUARY, Month.MAY, Month.AUGUST, Month.NOVEMBER);

        private final String prefix;
        private final Month winter;
        private final Month spring;
        private final Month summer;
        private final Month autumn;

        private SubSeason(String prefix, Month winter, Month spring, Month summer, Month autumn) {
            this.prefix = prefix;
            this.winter = winter;
            this.spring = spring;
            this.summer = summer;
            this.autumn = autumn;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Month getWinter() {
            return this.winter;
        }

        public Month getSpring() {
            return this.spring;
        }

        public Month getSummer() {
            return this.summer;
        }

        public Month getAutumn() {
            return this.autumn;
        }
    }
}

