/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.mods.ISeasonModHelper;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import io.github.lucaargolo.seasonsextras.FabricSeasonsExtras;
import java.time.LocalDateTime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FabricSeasonsHelper
implements ISeasonModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.fabricSeasonsLoaded() && Common.hasCalendarLoaded()) {
            return FabricSeasonsExtras.SEASON_CALENDAR_ITEM;
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        if (Common.fabricSeasonsLoaded()) {
            return FabricSeasons.CONFIG.isSeasonTiedWithSystemTime();
        }
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.level());
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public String getCurrentSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.level());
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public long getDate(Player player) {
        long dayLength = SeasonHudServer.getDayLength();
        int seasonLength = FabricSeasons.getCurrentSeason((Level)player.level()).getSeasonLength();
        long timeToNextSeason = FabricSeasons.getTimeToNextSeason((Level)player.level());
        if (this.isSeasonTiedWithSystemTime()) {
            return LocalDateTime.now().getDayOfMonth();
        }
        return ((long)seasonLength - timeToNextSeason) / dayLength + 1L;
    }

    @Override
    public int seasonDuration(Player player) {
        int dayLength = SeasonHudServer.getDayLength();
        int seasonLength = FabricSeasons.getCurrentSeason((Level)player.level()).getSeasonLength();
        return seasonLength / dayLength;
    }
}

