/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.mods.IModHelper;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class EclipticSeasonsHelper
implements IModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.eclipticSeasonsLoaded()) {
            return (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)"eclipticseasons", (String)"calendar"));
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        String currentSolarTerm = "MID_NULL";
        ResourceKey currentDim = Objects.requireNonNull(Minecraft.getInstance().level).dimension();
        List validDimensions = (List)CommonConfig.Season.validDimensions.get();
        if (Common.isDimensionValid(validDimensions, (ResourceKey<Level>)currentDim)) {
            currentSolarTerm = EclipticUtil.INSTANCE.getSolarTerm(player.level()).getName();
        }
        return currentSolarTerm;
    }

    @Override
    public String getCurrentSeason(Player player) {
        String currentSeason = "NULL";
        ResourceKey currentDim = Objects.requireNonNull(Minecraft.getInstance().level).dimension();
        List validDimensions = (List)CommonConfig.Season.validDimensions.get();
        if (Common.isDimensionValid(validDimensions, (ResourceKey<Level>)currentDim)) {
            currentSeason = EclipticUtil.INSTANCE.getSolarTerm(player.level()).getSeason().toString();
        }
        return currentSeason;
    }

    @Override
    public long getDate(Player player) {
        long seasonDay = EclipticUtil.getNowSolarDay((Level)player.level());
        long subSeasonDay = EclipticUtil.getTimeInSolarTerm((Level)player.level());
        long subSeasonDuration = ((Integer)CommonConfig.Season.lastingDaysOfEachTerm.get()).intValue();
        long subSeasonDate = subSeasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 6L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            return subSeasonDate;
        }
        return seasonDate;
    }

    @Override
    public int seasonDuration(Player player) {
        int duration = (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() * 6;
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            duration /= 6;
        }
        return duration;
    }
}

