/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HudScaleSlider
extends BasicSlider {
    protected final Component prefix;

    protected HudScaleSlider(int x, int y, int width, int height, Component prefix, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision) {
        super(x, y, width, height, true, initial, minValue, maxValue, defaultValue, stepSize, precision);
        this.prefix = prefix;
        this.updateMessage();
    }

    public static Builder builder(Component prefix) {
        return new Builder(prefix);
    }

    @Override
    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((Component)Common.literalText("").append(this.prefix).append(this.getValueString()));
        } else {
            this.setMessage((Component)Component.empty());
        }
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }

    public static class Builder {
        protected final Component prefix;
        protected int x;
        protected int y;
        protected int width = 180;
        protected int height = 20;
        protected double minValue;
        protected double maxValue;
        protected double initial;
        protected double defaultValue;
        protected Tooltip tooltip;
        protected double stepSize;
        protected int precision;

        public Builder(Component prefix) {
            this.prefix = prefix;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withValueRange(double minValue, double maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        public Builder withInitialValue(double initial) {
            this.initial = initial;
            return this;
        }

        public Builder withDefaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withStepSize(double stepSize) {
            this.stepSize = stepSize;
            return this;
        }

        public Builder withPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder withTooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public HudScaleSlider build() {
            HudScaleSlider slider = new HudScaleSlider(this.x, this.y, this.width, this.height, this.prefix, this.initial, this.minValue, this.maxValue, this.defaultValue, this.stepSize, this.precision);
            slider.setTooltip(this.tooltip);
            return slider;
        }
    }
}

