/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.boxes;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class ColorEditBox
extends EditBox {
    private static final int PADDING = 4;
    private final Seasons boxSeason;
    private final int seasonColor;
    private int newSeasonColor;

    public ColorEditBox(Font font, int x, int y, int width, int height, Seasons season) {
        super(font, x, y, width, height, season.getSeasonName());
        this.boxSeason = season;
        this.newSeasonColor = this.seasonColor = season.getSeasonColor();
        this.m_94199_(8);
        this.m_94144_(String.valueOf(this.seasonColor));
        this.m_94151_(colorString -> {
            if (this.validate((String)colorString)) {
                this.m_94202_(0xFFFFFF);
                int colorInt = Integer.parseInt(colorString);
                if (colorInt != this.newSeasonColor) {
                    this.newSeasonColor = colorInt;
                    this.m_94144_((String)colorString);
                }
                ColorScreen.doneButton.f_93623_ = true;
            } else {
                this.m_94202_(0xFF5555);
                ColorScreen.doneButton.f_93623_ = false;
            }
        });
        this.m_94186_(SeasonHudClient.getEnableSeasonNameColor());
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }

    public void save() {
        Rgb.setRgb(this.boxSeason, this.newSeasonColor);
        this.boxSeason.setSeasonColor(this.newSeasonColor);
    }

    public int getColor() {
        return this.seasonColor;
    }

    public int getNewColor() {
        return this.newSeasonColor;
    }

    public Seasons getSeason() {
        return this.boxSeason;
    }

    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        int widgetTotalSize;
        Minecraft mc = Minecraft.m_91087_();
        float textScale = 1.0f;
        int scaledWidth = mc.m_91268_().m_85445_();
        boolean seasonShort = scaledWidth < (widgetTotalSize = 86 * ColorEditBox.seasonListSet().size());
        MutableComponent seasonCombined = CurrentSeason.getInstance(mc).getMenuText(this.boxSeason, this.newSeasonColor, seasonShort);
        graphics.m_85836_();
        if (mc.f_91062_.m_92852_((FormattedText)seasonCombined) > this.m_5711_() - 4) {
            textScale = ((float)this.m_5711_() - 4.0f) / (float)mc.f_91062_.m_92852_((FormattedText)seasonCombined);
        }
        graphics.m_85841_(textScale, textScale, 1.0f);
        Font font = mc.f_91062_;
        int n = (int)(((double)this.f_93620_ + (double)this.m_5711_() / 2.0) / (double)textScale);
        float f = this.f_93621_;
        Objects.requireNonNull(mc.f_91062_);
        ColorEditBox.m_93215_((PoseStack)graphics, (Font)font, (Component)seasonCombined, (int)n, (int)((int)((f - 9.0f * textScale - 4.0f) / textScale)), (int)0xFFFFFF);
        graphics.m_85849_();
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
    }
}

