/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class HudOffsetSlider
extends BasicSlider {
    protected final Component prefix;
    private final OptionInstance.TooltipSupplier<List<FormattedCharSequence>> tooltipSupplier;

    protected HudOffsetSlider(int x, int y, int width, int height, Component prefix, int initial, int minValue, int maxValue, int defaultValue, OptionInstance.TooltipSupplier<List<FormattedCharSequence>> tooltipSupplier) {
        super(x, y, width, height, true, initial, minValue, maxValue, defaultValue);
        this.prefix = prefix;
        this.tooltipSupplier = tooltipSupplier;
        this.m_5695_();
    }

    public static Builder builder(Component prefix) {
        return new Builder(prefix);
    }

    @Override
    protected void m_5695_() {
        if (this.drawString) {
            this.m_93666_((Component)Common.literalText("").m_7220_(this.prefix).m_130946_(this.getValueString()));
        } else {
            this.m_93666_((Component)Component.m_237119_());
        }
    }

    @Override
    public void m_7906_(@NotNull PoseStack graphics, @NotNull Minecraft mc, int mouseX, int mouseY) {
        super.m_7906_(graphics, mc, mouseX, mouseY);
    }

    public static class Builder {
        protected final Component prefix;
        protected int x;
        protected int y;
        protected int width = 180;
        protected int height = 20;
        protected int minValue;
        protected int maxValue;
        protected int initial;
        protected int defaultValue;
        protected OptionInstance.TooltipSupplier<List<FormattedCharSequence>> tooltipSupplier;

        public Builder(Component prefix) {
            this.prefix = prefix;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withValueRange(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        public Builder withInitialValue(int initial) {
            this.initial = initial;
            return this;
        }

        public Builder withDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withValues(int minValue, int maxValue, int initial, int defaultValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.defaultValue = defaultValue;
            this.initial = Mth.m_14045_((int)initial, (int)this.minValue, (int)this.maxValue);
            return this;
        }

        public Builder withTooltip(OptionInstance.TooltipSupplier<List<FormattedCharSequence>> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public HudOffsetSlider build() {
            HudOffsetSlider slider = new HudOffsetSlider(this.x, this.y, this.width, this.height, this.prefix, this.initial, this.minValue, this.maxValue, this.defaultValue, this.tooltipSupplier);
            return slider;
        }
    }
}

