/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.Location;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.client.gui.components.sliders.HudOffsetSlider;
import club.iananderson.seasonhud.client.gui.components.sliders.HudScaleSlider;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class SeasonOptionsScreen
extends SeasonHudScreen {
    private static final Component SCREEN_TITLE = Common.translatedText("menu.seasonhud.season.title");
    private Location hudLocation;
    private int xSliderInt;
    private int ySliderInt;
    private double seasonScale;
    private ShowDay showDay;
    private boolean seasonColor;
    private boolean showSubSeason;
    private boolean showTropicalSeason;
    private boolean showFertility;
    private boolean needCalendar;
    private boolean enableCalendarDetail;
    private boolean drawDefaultHud;
    private int dayLength;
    private int newDayLength;
    private CycleButton<Location> hudLocationButton;
    private HudOffsetSlider xSlider;
    private HudOffsetSlider ySlider;
    private HudScaleSlider hudScaleSlider;
    private EditBox dayLengthBox;

    public SeasonOptionsScreen(Screen parentScreen) {
        super(parentScreen, SCREEN_TITLE);
    }

    public static SeasonOptionsScreen getInstance(Screen parentScreen) {
        return new SeasonOptionsScreen(parentScreen);
    }

    public void loadConfig() {
        this.drawDefaultHud = Common.drawDefaultHudMenu();
        this.hudLocation = SeasonHudClient.getHudLocation();
        this.xSliderInt = SeasonHudClient.getHudX();
        this.ySliderInt = SeasonHudClient.getHudY();
        this.seasonScale = SeasonHudClient.getHudScale();
        this.showDay = SeasonHudClient.getShowDay();
        this.seasonColor = SeasonHudClient.getEnableSeasonNameColor();
        this.showSubSeason = SeasonHudClient.getShowSubSeason();
        this.showTropicalSeason = SeasonHudClient.getShowTropicalSeason();
        if (Common.hasCalendarLoaded()) {
            this.needCalendar = SeasonHudServer.getNeedCalendar();
            this.enableCalendarDetail = SeasonHudServer.getCalendarDetailMode();
        }
        if (Common.fabricSeasonsLoaded()) {
            this.dayLength = SeasonHudServer.getDayLength();
        }
        if (Common.sereneSeasonsLoaded()) {
            this.showFertility = SeasonHudClient.getShowFertility();
        }
    }

    @Override
    public void saveConfig() {
        if (this.drawDefaultHud) {
            SeasonHudClient.setHudLocation((Location)((Object)this.hudLocationButton.m_168883_()));
            SeasonHudClient.setHudX(this.xSlider.getValueInt());
            SeasonHudClient.setHudY(this.ySlider.getValueInt());
            SeasonHudClient.setHudScale(this.hudScaleSlider.getValueDouble());
        }
        SeasonHudClient.setShowDay(this.showDay);
        SeasonHudClient.setEnableSeasonNameColor(this.seasonColor);
        if (Common.hasSubSeasons()) {
            SeasonHudClient.setShowSubSeason(this.showSubSeason);
            SeasonHudClient.setShowTropicalSeason(this.showTropicalSeason);
        }
        if (Common.clientSideConfig()) {
            if (Common.hasCalendarLoaded()) {
                SeasonHudServer.setCalendarDetailMode(this.enableCalendarDetail);
                SeasonHudServer.setNeedCalendar(this.needCalendar);
            }
            if (Common.fabricSeasonsLoaded()) {
                SeasonHudServer.setDayLength(Integer.parseInt(this.dayLengthBox.m_94155_()));
            }
        }
        if (Common.sereneSeasonsLoaded()) {
            SeasonHudClient.setShowFertility(this.showFertility);
        }
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
    }

    @Override
    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
        int x = 3;
        int y = 3;
        this.seasonScale = 1.0;
        MutableComponent seasonCombined = CurrentSeason.getInstance(this.f_96541_).getConfigText(this.showDay, this.showSubSeason, this.seasonColor);
        MutableComponent fertility = CurrentFertility.getInstance(this.f_96541_).getHudText();
        if (this.drawDefaultHud) {
            int DEFAULT_X_OFFSET_SCALED = 2;
            int DEFAULT_Y_OFFSET_SCALED = 2;
            this.seasonScale = this.hudScaleSlider.getValueDouble();
            int componentWidth = (int)((double)this.f_96547_.m_92852_((FormattedText)seasonCombined) * this.seasonScale);
            Objects.requireNonNull(this.f_96547_);
            int componentHeight = (int)(9.0 * this.seasonScale);
            boolean customLocation = this.hudLocationButton.m_168883_() == Location.CUSTOM;
            this.hudScaleSlider.f_93624_ = this.drawDefaultHud;
            this.xSlider.f_93623_ = customLocation;
            this.xSlider.f_93624_ = this.drawDefaultHud;
            this.ySlider.f_93623_ = customLocation;
            this.ySlider.f_93624_ = this.drawDefaultHud;
            switch (this.hudLocation) {
                case TOP_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_CENTER: {
                    x = (int)(((double)this.f_96543_ / 2.0 - (double)componentWidth / 2.0) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case TOP_RIGHT: {
                    x = (int)((double)(this.f_96543_ - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = DEFAULT_Y_OFFSET_SCALED;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = DEFAULT_X_OFFSET_SCALED;
                    y = (int)((double)(this.f_96544_ - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = (int)((double)(this.f_96543_ - componentWidth - DEFAULT_X_OFFSET_SCALED) / this.seasonScale);
                    y = (int)((double)(this.f_96544_ - componentHeight - DEFAULT_Y_OFFSET_SCALED) / this.seasonScale);
                    break;
                }
                case CUSTOM: {
                    x = this.xSlider.getValueInt();
                    y = this.ySlider.getValueInt();
                }
            }
        }
        if (Common.fabricSeasonsLoaded() && Common.clientSideConfig()) {
            int row = 4;
            if (Common.fabricSeasonsExtrasLoaded()) {
                ++row;
            }
            if (!this.drawDefaultHud) {
                row -= 2;
            }
            int n = this.leftButtonX + this.BUTTON_WIDTH / 2;
            Objects.requireNonNull(this.f_96547_);
            GuiComponent.m_93208_((PoseStack)graphics, (Font)this.f_96547_, (String)"Day Length", (int)n, (int)(50 + row * (this.BUTTON_HEIGHT + 6) - (9 + 6)), (int)0xFFFFFF);
        }
        graphics.m_85836_();
        graphics.m_85837_(0.0, 0.0, 50.0);
        graphics.m_85841_((float)this.seasonScale, (float)this.seasonScale, 1.0f);
        GuiComponent.m_93243_((PoseStack)graphics, (Font)this.f_96547_, (Component)seasonCombined, (int)x, (int)y, (int)0xFFFFFF);
        if (this.showFertility) {
            Objects.requireNonNull(this.f_96547_);
            GuiComponent.m_93243_((PoseStack)graphics, (Font)this.f_96547_, (Component)fertility, (int)x, (int)(y += 9), (int)0xFFFFFF);
        }
        graphics.m_85849_();
    }

    private int maxWidth(MutableComponent seasonText) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)seasonText);
        return (int)(((double)this.f_96543_ - (double)textWidth * this.seasonScale) / this.seasonScale);
    }

    private int maxHeight() {
        Objects.requireNonNull(this.f_96547_);
        int textHeight = 9;
        return (int)(((double)this.f_96544_ - (double)textHeight * this.seasonScale) / this.seasonScale);
    }

    @Override
    public void m_7856_() {
        this.loadConfig();
        super.m_7856_();
        MutableComponent seasonCombined = CurrentSeason.getInstance(this.f_96541_).getHudText();
        this.row = -1;
        if (this.drawDefaultHud) {
            ++this.row;
            this.hudLocationButton = CycleButton.m_168894_(Location::getLocationName).m_232498_(t -> Common.newTooltip("menu.seasonhud.season.hudLocation.tooltip")).m_168961_((Object[])Location.values()).m_168948_((Object)this.hudLocation).m_168936_(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.hudLocation.button"), (b, val) -> {
                this.hudLocation = val;
            });
            this.hudScaleSlider = HudScaleSlider.builder((Component)Common.translatedText("menu.seasonhud.season.scale.slider")).withTooltip((OptionInstance.TooltipSupplier<List<FormattedCharSequence>>)((OptionInstance.TooltipSupplier)t -> Common.newTooltip("menu.seasonhud.season.scale.tooltip"))).withValueRange(0.5, 10.0).withInitialValue(this.seasonScale).withDefaultValue(1.0).withStepSize(0.5).withPrecision(1).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT).build();
            ++this.row;
            this.xSlider = HudOffsetSlider.builder((Component)Common.translatedText("menu.seasonhud.season.xOffset.slider")).withTooltip((OptionInstance.TooltipSupplier<List<FormattedCharSequence>>)((OptionInstance.TooltipSupplier)t -> Common.newTooltip("menu.seasonhud.season.xOffset.tooltip"))).withValues(0, this.maxWidth(seasonCombined), this.xSliderInt, 2).withBounds(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.ySlider = HudOffsetSlider.builder((Component)Common.translatedText("menu.seasonhud.season.yOffset.slider")).withTooltip((OptionInstance.TooltipSupplier<List<FormattedCharSequence>>)((OptionInstance.TooltipSupplier)t -> Common.newTooltip("menu.seasonhud.season.yOffset.tooltip"))).withValues(0, this.maxHeight(), this.ySliderInt, 2).withBounds(this.rightButtonX + this.BUTTON_WIDTH / 2 + 2, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH / 2 - 2, this.BUTTON_HEIGHT).build();
            this.widgets.addAll(Arrays.asList(new AbstractWidget[]{this.hudLocationButton, this.hudScaleSlider, this.xSlider, this.ySlider}));
        }
        ++this.row;
        CycleButton showDayButton = CycleButton.m_168894_(ShowDay::getDayDisplayName).m_232498_(t -> Common.newTooltip("menu.seasonhud.season.showDay.tooltip")).m_232502_(ShowDay.getValues()).m_168948_((Object)this.showDay).m_168936_(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showDay.button"), (b, val) -> {
            this.showDay = val;
        });
        CycleButton seasonColorButton = CycleButton.m_168916_((boolean)this.seasonColor).m_232498_(t -> Common.newTooltip("menu.seasonhud.color.enableSeasonNameColor.tooltip")).m_168936_(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.color.enableSeasonNameColor.button"), (b, val) -> {
            this.seasonColor = val;
        });
        this.widgets.addAll(Arrays.asList(showDayButton, seasonColorButton));
        if (Common.hasSubSeasons()) {
            ++this.row;
            CycleButton showSubSeasonButton = CycleButton.m_168916_((boolean)this.showSubSeason).m_232498_(t -> Common.newTooltip("menu.seasonhud.season.showSubSeason.tooltip")).m_168936_(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showSubSeason.button"), (b, val) -> {
                this.showSubSeason = val;
            });
            CycleButton showTropicalSeasonButton = CycleButton.m_168916_((boolean)this.showTropicalSeason).m_232498_(t -> Common.newTooltip("menu.seasonhud.season.showTropicalSeason.tooltip")).m_168936_(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showTropicalSeason.button"), (b, val) -> {
                this.showTropicalSeason = val;
            });
            this.widgets.addAll(Arrays.asList(showSubSeasonButton, showTropicalSeasonButton));
        }
        if (Common.hasCalendarLoaded()) {
            ++this.row;
            CycleButton needCalendarButton = CycleButton.m_168916_((boolean)this.needCalendar).m_232498_(t -> {
                if (!Common.clientSideConfig()) {
                    return Common.newTooltip("menu.seasonhud.season.serverSide.tooltip");
                }
                return Common.newTooltip("menu.seasonhud.season.needCalendar.tooltip");
            }).m_168936_(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.needCalendar.button"), (b, val) -> {
                this.needCalendar = val;
            });
            needCalendarButton.f_93623_ = Common.clientSideConfig();
            CycleButton calendarDetailModeButton = CycleButton.m_168916_((boolean)this.enableCalendarDetail).m_232498_(t -> {
                if (!Common.clientSideConfig()) {
                    return Common.newTooltip("menu.seasonhud.season.serverSide.tooltip");
                }
                return Common.newTooltip("menu.seasonhud.season.calendarDetail.tooltip");
            }).m_168936_(this.rightButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.calendarDetail.button"), (b, val) -> {
                this.enableCalendarDetail = val;
            });
            if (!Common.clientSideConfig()) {
                needCalendarButton.f_93623_ = false;
                calendarDetailModeButton.f_93623_ = false;
            }
            this.widgets.addAll(Arrays.asList(needCalendarButton, calendarDetailModeButton));
        }
        if (Common.sereneSeasonsLoaded()) {
            ++this.row;
            CycleButton showFertilityButton = CycleButton.m_168916_((boolean)this.showFertility).m_232498_(t -> Common.newTooltip("menu.seasonhud.season.showFertility.tooltip")).m_168936_(this.leftButtonX, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (Component)Common.translatedText("menu.seasonhud.season.showFertility.button"), (b, val) -> {
                this.showFertility = val;
            });
            this.widgets.add(showFertilityButton);
        }
        if (Common.fabricSeasonsLoaded()) {
            this.row += 2;
            this.dayLengthBox = new EditBox(this.f_96547_, this.leftButtonX + 1, this.buttonStartY + this.row * this.yOffset, this.BUTTON_WIDTH - 2, this.BUTTON_HEIGHT, (Component)Common.literalText(String.valueOf(this.dayLength)));
            this.dayLengthBox.m_94199_(10);
            this.dayLengthBox.m_94144_(String.valueOf(this.dayLength));
            this.dayLengthBox.m_94151_(lengthString -> {
                if (this.validate((String)lengthString)) {
                    this.dayLengthBox.m_94202_(0xFFFFFF);
                    int currentLength = Integer.parseInt(lengthString);
                    if (currentLength != this.newDayLength) {
                        this.newDayLength = currentLength;
                        this.dayLengthBox.m_94144_(lengthString);
                    }
                    SeasonOptionsScreen.doneButton.f_93623_ = true;
                } else {
                    this.dayLengthBox.m_94202_(0xFF5555);
                    SeasonOptionsScreen.doneButton.f_93623_ = false;
                }
            });
            this.dayLengthBox.f_93624_ = Common.clientSideConfig();
            this.widgets.add(this.dayLengthBox);
        }
        this.widgets.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private boolean inBounds(int length) {
        int minInt = 0;
        return length >= minInt;
    }

    public boolean validate(String length) {
        try {
            int dayLength = Integer.parseInt(length);
            return this.inBounds(dayLength);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }
}

