/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.Fertility;
import club.iananderson.seasonhud.impl.seasons.mods.ISeasonModHelper;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class EclipticSeasonsHelper
implements ISeasonModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.eclipticSeasonsLoaded()) {
            return (Item)Registry.f_122827_.m_7745_(new ResourceLocation("eclipticseasons", "calendar"));
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        String currentSolarTerm = "MID_NULL";
        ResourceKey currentDim = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46472_();
        List<String> validDimensions = List.of(Level.f_46428_.m_135782_().toString());
        if (Common.isDimensionValid(validDimensions, (ResourceKey<Level>)currentDim)) {
            currentSolarTerm = EclipticUtil.INSTANCE.getSolarTerm(player.f_19853_).getName();
        }
        return currentSolarTerm;
    }

    @Override
    public String getCurrentSeason(Player player) {
        String currentSeason = "NULL";
        ResourceKey currentDim = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46472_();
        List<String> validDimensions = List.of(Level.f_46428_.m_135782_().toString());
        if (Common.isDimensionValid(validDimensions, (ResourceKey<Level>)currentDim)) {
            currentSeason = EclipticUtil.INSTANCE.getSolarTerm(player.f_19853_).getSeason().toString();
        }
        return currentSeason;
    }

    @Override
    public long getDate(Player player) {
        long seasonDay = EclipticUtil.getNowSolarDay((Level)player.f_19853_);
        long subSeasonDay = EclipticUtil.getTimeInSolarTerm((Level)player.f_19853_);
        long subSeasonDuration = ((Integer)CommonConfig.Season.lastingDaysOfEachTerm.get()).intValue();
        long subSeasonDate = subSeasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 6L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            return subSeasonDate;
        }
        return seasonDate;
    }

    @Override
    public int seasonDuration(Player player) {
        int duration = (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get() * 6;
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            duration /= 6;
        }
        return duration;
    }

    @Override
    public boolean infertileBiome(Player player) {
        return false;
    }

    @Override
    public boolean alwaysWinterBiome(Player player) {
        return false;
    }

    @Override
    public boolean undergroundFertile(Player player) {
        return true;
    }

    @Override
    public Fertility fertility(Player player) {
        return Fertility.FERTILE;
    }
}

