/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.Fertility;
import club.iananderson.seasonhud.impl.seasons.mods.ISeasonModHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.ServerConfig;

public class SereneSeasonsHelper
implements ISeasonModHelper {
    @Override
    public Item CALENDAR() {
        return (Item)Registry.f_122827_.m_7745_(new ResourceLocation("sereneseasons", "calendar"));
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        boolean showTropicalSeasons = SeasonHudClient.getShowTropicalSeason();
        boolean isInTropicalSeason = SeasonHelper.usesTropicalSeasons((Holder)player.f_19853_.m_204166_(player.m_20097_()));
        return showTropicalSeasons && isInTropicalSeason;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.f_19853_);
        if (this.isTropicalSeason(player)) {
            return currentSeasonState.getTropicalSeason().toString();
        }
        return currentSeasonState.getSubSeason().toString();
    }

    @Override
    public String getCurrentSeason(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.f_19853_);
        if (this.isTropicalSeason(player)) {
            String currentSubSeason = this.getCurrentSubSeason(player);
            return currentSubSeason.substring(currentSubSeason.length() - 3);
        }
        return currentSeasonState.getSeason().toString();
    }

    @Override
    public long getDate(Player player) {
        ISeasonState currentSeasonState = SeasonHelper.getSeasonState((Level)player.f_19853_);
        long seasonDay = currentSeasonState.getDay();
        long subSeasonDuration = ((Integer)ServerConfig.subSeasonDuration.get()).intValue();
        long subSeasonDate = seasonDay % subSeasonDuration + 1L;
        long seasonDate = seasonDay % (subSeasonDuration * 3L) + 1L;
        if (SeasonHudClient.getShowSubSeason()) {
            if (this.isTropicalSeason(player)) {
                subSeasonDate = (seasonDay + subSeasonDuration * 3L) % (subSeasonDuration * 2L) + 1L;
            }
            return subSeasonDate;
        }
        if (this.isTropicalSeason(player)) {
            seasonDate = (seasonDay + subSeasonDuration * 3L) % (subSeasonDuration * 6L) + 1L;
        }
        return seasonDate;
    }

    @Override
    public int seasonDuration(Player player) {
        int duration = (Integer)ServerConfig.subSeasonDuration.get() * 3;
        if (this.isTropicalSeason(player)) {
            duration *= 2;
        }
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            duration /= 3;
        }
        return duration;
    }

    @Override
    public boolean infertileBiome(Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_20097_();
        Holder biome = level.m_204166_(pos);
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((Holder)biome) && ServerConfig.isDimensionWhitelisted((ResourceKey)level.m_46472_()))) {
            return false;
        }
        return BiomeConfig.infertileBiome((Holder)biome);
    }

    @Override
    public boolean alwaysWinterBiome(Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_20097_();
        Holder biome = level.m_204166_(pos);
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((Holder)biome) && ServerConfig.isDimensionWhitelisted((ResourceKey)level.m_46472_()))) {
            return false;
        }
        return !((Biome)biome.m_203334_()).m_198906_(pos);
    }

    @Override
    public boolean undergroundFertile(Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_20097_();
        Holder biome = level.m_204166_(pos);
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((Holder)biome) && ServerConfig.isDimensionWhitelisted((ResourceKey)level.m_46472_()))) {
            return true;
        }
        if (!level.m_45527_(pos.m_7494_())) {
            return pos.m_123342_() > (Integer)FertilityConfig.undergroundFertilityLevel.get();
        }
        return true;
    }

    @Override
    public Fertility fertility(Player player) {
        if (this.infertileBiome(player)) {
            return Fertility.INFERTILE_BIOME;
        }
        if (this.alwaysWinterBiome(player)) {
            return Fertility.ALWAYS_WINTER;
        }
        if (!this.undergroundFertile(player)) {
            return Fertility.UNDERGROUND;
        }
        return Fertility.FERTILE;
    }
}

