/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.util.DrawUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BasicSlider
extends AbstractSliderButton {
    public static final int SLIDER_PADDING = 2;
    protected static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("seasonhud:textures/gui/slider.png");
    protected boolean drawString;
    protected boolean canChangeValue;
    protected double minValue;
    protected double maxValue;
    protected double defaultValue;
    protected double stepSize;
    protected ChatFormatting textColor;
    private DecimalFormat format;

    private BasicSlider(int x, int y, int width, int height, boolean drawString, double initial) {
        super(x, y, width, height, (Component)new TextComponent(""), 0.0);
        this.drawString = drawString;
        this.f_93577_ = this.snapToNearest(initial);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision, ChatFormatting textColor) {
        this(x, y, width, height, drawString, initial);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.f_93577_ = this.snapToNearest((initial - minValue) / (maxValue - minValue));
        this.stepSize = Math.abs(stepSize);
        this.textColor = textColor;
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = Mth.m_14082_((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.m_5695_();
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, ChatFormatting textColor) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, textColor);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue, double stepSize, int precision) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, stepSize, precision, ChatFormatting.WHITE);
    }

    protected BasicSlider(int x, int y, int width, int height, boolean drawString, double initial, double minValue, double maxValue, double defaultValue) {
        this(x, y, width, height, drawString, initial, minValue, maxValue, defaultValue, 1.0, 0, ChatFormatting.WHITE);
    }

    protected static void renderScrollingString(PoseStack graphics, Font font, Component component, int i, int j, int k, int l, int m, int n) {
        int o = font.m_92852_((FormattedText)component);
        int var10000 = k + m;
        Objects.requireNonNull(font);
        int p = (var10000 - 9) / 2 + 1;
        int q = l - j;
        if (o > q) {
            int r = o - q;
            double d = (double)Util.m_137550_() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.m_14139_((double)f, (double)0.0, (double)r);
            DrawUtil.enableScissor(j, k, l, m);
            GuiComponent.m_93243_((PoseStack)graphics, (Font)font, (Component)component, (int)(j - (int)g), (int)p, (int)n);
            DrawUtil.disableScissor();
        } else {
            int r = Mth.m_14045_((int)i, (int)(j + o / 2), (int)(l - o / 2));
            GuiComponent.m_93215_((PoseStack)graphics, (Font)font, (Component)component, (int)r, (int)p, (int)n);
        }
    }

    protected static void renderScrollingString(PoseStack graphics, Font font, Component component, int i, int j, int k, int l, int m) {
        BasicSlider.renderScrollingString(graphics, font, component, (i + k) / 2, i, j, k, l, m);
    }

    public void onRightClick() {
        this.setValue(this.defaultValue);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean rightClicked;
        if (this.f_93623_ && this.f_93624_ && mouseButton == 1 && (rightClicked = this.m_93680_(mouseX, mouseY))) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onRightClick();
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public int getTextureY() {
        int i = this.m_93696_() && !this.canChangeValue ? 1 : 0;
        return i * 20;
    }

    public int getHandleTextureY() {
        int i = !this.f_93622_ && !this.canChangeValue ? 2 : 3;
        return i * 20;
    }

    public int getFGColor() {
        return this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
    }

    protected double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        }
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? Mth.m_14008_((double)value, (double)this.maxValue, (double)this.minValue) : Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.m_144914_((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.f_93577_ = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.m_5695_();
    }

    public double getValueDouble() {
        return (double)Math.round(this.getValue() * 10.0) / 10.0;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void setSliderValue(double value) {
        double oldValue = this.f_93577_;
        this.f_93577_ = this.snapToNearest(value);
        if (!Mth.m_14082_((double)oldValue, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    protected void m_5697_() {
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                bl = !bl;
            }
            float f2 = f = bl ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.f_93577_ + (double)(f / (float)(this.f_93618_ - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    protected void m_5695_() {
        if (this.drawString) {
            this.m_93666_((Component)Common.literalText(this.getValueString()));
        } else {
            this.m_93666_((Component)new TextComponent(""));
        }
    }

    protected void renderScrollingString(PoseStack graphics, Font font, int i, int j) {
        int k = this.f_93620_ + i;
        int l = this.f_93620_ + this.m_5711_() - i;
        BasicSlider.renderScrollingString(graphics, font, this.m_6035_(), k, this.f_93621_, l, this.f_93621_ + this.m_93694_(), j);
    }

    protected void m_7906_(@NotNull PoseStack graphics, @NotNull Minecraft mc, int mouseX, int mouseY) {
        DrawUtil.blitWithBorder(graphics, (GuiComponent)this, SLIDER_LOCATION, this.f_93620_, this.f_93621_, 0, this.getTextureY(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
        DrawUtil.blitWithBorder(graphics, (GuiComponent)this, SLIDER_LOCATION, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.f_93621_, 0, this.getHandleTextureY(), 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
        this.renderScrollingString(graphics, mc.f_91062_, 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }
}

