/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.util.DrawUtil;
import club.iananderson.seasonhud.util.Rgb;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorButton
extends Button {
    private static final Component DEFAULT = Common.translatedText("menu.seasonhud.color.default.button");
    private final ColorEditBox colorEditBox;
    private final int defaultColor;

    private DefaultColorButton(int x, int y, ColorEditBox colorEditBox, Button.OnPress onPress) {
        super(x, y, colorEditBox.m_5711_() + 2, colorEditBox.m_93694_() - 2, DEFAULT, onPress, f_252438_);
        this.colorEditBox = colorEditBox;
        this.defaultColor = colorEditBox.getSeason().getDefaultColor();
    }

    public static Builder builder(ColorEditBox colorEditBox, Button.OnPress onPress) {
        return new Builder(colorEditBox, onPress);
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException var) {
            return false;
        }
    }

    public int getTextureY() {
        int k = 1;
        if (!this.f_93623_) {
            k = 0;
        } else if (this.m_198029_()) {
            k = 2;
        }
        return 46 + k * 20;
    }

    public int getFGColor() {
        return this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int i, int j, float f) {
        Minecraft mc = Minecraft.m_91087_();
        DrawUtil.blitWithBorder(graphics, f_93617_, this.m_252754_(), this.m_252907_(), 0, this.getTextureY(), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
        Component buttonText = this.m_6035_();
        graphics.m_280364_(mc.f_91062_, Language.m_128107_().m_5536_((FormattedText)buttonText), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, this.getFGColor());
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.refresh();
        String boxValue = this.colorEditBox.m_94155_();
        if (this.validate(boxValue) && Integer.parseInt(boxValue) == this.defaultColor) {
            this.f_93623_ = false;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void refresh() {
        Map<String, Integer> currentColors;
        Map<String, Integer> defaultColors = Rgb.defaultSeasonMap(this.colorEditBox.getSeason());
        this.f_93623_ = defaultColors != (currentColors = this.colorEditBox.getSeason().getRgbMap());
    }

    public static class Builder {
        protected final Button.OnPress onPress;
        protected final ColorEditBox colorEditBox;
        protected int x;
        protected int y;
        protected Tooltip tooltip;

        public Builder(ColorEditBox colorEditBox, Button.OnPress onPress) {
            this.colorEditBox = colorEditBox;
            this.onPress = onPress;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withTooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public DefaultColorButton build() {
            DefaultColorButton button = new DefaultColorButton(this.x, this.y, this.colorEditBox, this.onPress);
            button.m_257544_(this.tooltip);
            return button;
        }
    }
}

