/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import com.demonwav.mcdev.annotations.Translatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Common {
    public static final String MOD_ID = "seasonhud";
    public static final String MOD_NAME = "SeasonHUD";
    public static final Logger LOG = LogManager.getLogger((String)"SeasonHUD");
    public static final ResourceLocation SEASON_ICONS = Common.location("season_icons");
    public static final Style SEASON_ICON_STYLE = Style.field_240709_b_.func_240719_a_(SEASON_ICONS);
    public static ResourceLocation slotIcon = new ResourceLocation("seasonhud", "slot/calendarslot");
    private static String platformName;
    private static boolean sereneSeasonsLoaded;
    private static boolean fabricSeasonsLoaded;
    private static boolean fabricSeasonsExtrasLoaded;
    private static boolean terrafirmacraftLoaded;
    private static boolean eclipticSeasonsLoaded;
    private static boolean curiosLoaded;
    private static boolean trinketsLoaded;
    private static boolean accessoriesLoaded;

    private Common() {
    }

    public static void init() {
        platformName = Services.PLATFORM.getPlatformName();
        sereneSeasonsLoaded = Services.PLATFORM.isModLoaded("sereneseasons");
        fabricSeasonsLoaded = Services.PLATFORM.isModLoaded("seasons");
        fabricSeasonsExtrasLoaded = Services.PLATFORM.isModLoaded("seasonsextras");
        terrafirmacraftLoaded = Services.PLATFORM.isModLoaded("tfc");
        eclipticSeasonsLoaded = Services.PLATFORM.isModLoaded("eclipticseasons");
        curiosLoaded = Services.PLATFORM.isModLoaded("curios");
        trinketsLoaded = Services.PLATFORM.isModLoaded("trinkets");
        accessoriesLoaded = Services.PLATFORM.isModLoaded("accessories");
    }

    public static String platformName() {
        return platformName;
    }

    public static boolean sereneSeasonsLoaded() {
        return sereneSeasonsLoaded;
    }

    public static boolean fabricSeasonsLoaded() {
        return fabricSeasonsLoaded;
    }

    public static boolean fabricSeasonsExtrasLoaded() {
        return fabricSeasonsExtrasLoaded;
    }

    public static boolean terrafirmacraftLoaded() {
        return terrafirmacraftLoaded;
    }

    public static boolean eclipticSeasonsLoaded() {
        return eclipticSeasonsLoaded;
    }

    public static boolean curiosLoaded() {
        return curiosLoaded;
    }

    public static boolean trinketsLoaded() {
        return trinketsLoaded;
    }

    public static boolean accessoriesLoaded() {
        return accessoriesLoaded;
    }

    public static boolean hasCalendarLoaded() {
        return Common.fabricSeasonsExtrasLoaded() || Common.sereneSeasonsLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean hasSubSeasons() {
        return Common.sereneSeasonsLoaded() || Common.terrafirmacraftLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean clientSideConfig() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.func_147104_D() == null;
    }

    public static boolean vanillaShouldDrawHud() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        return (mc.field_71462_r == null || mc.field_71462_r instanceof ChatScreen || mc.field_71462_r instanceof DeathScreen) && !mc.field_71474_y.field_74330_P && !mc.field_71474_y.field_74319_N;
    }

    public static boolean minimapIntegrationHidden() {
        return SeasonHudClient.getEnableMinimapIntegration() && CurrentMinimap.allMinimapsHidden() && SeasonHudClient.getShowDefaultWhenMinimapHidden();
    }

    public static boolean drawDefaultHud() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || Common.minimapIntegrationHidden());
    }

    public static boolean drawDefaultHudMenu() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || SeasonHudClient.getShowDefaultWhenMinimapHidden());
    }

    public static boolean hideHudInCurrentDimension() {
        return Services.MINIMAP.hideHudInCurrentDimension();
    }

    public static boolean allTrue(List<Boolean> values) {
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static IFormattableTextComponent literalText(String text) {
        return new StringTextComponent(text);
    }

    public static IFormattableTextComponent translatedText(@Translatable(foldMethod=true) String key) {
        return new TranslationTextComponent(key);
    }

    public static IFormattableTextComponent translatedText(@Translatable(foldMethod=true) String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }

    public static List<IReorderingProcessor> newTooltip(@Translatable(foldMethod=true) String key) {
        ArrayList<IReorderingProcessor> List2 = new ArrayList<IReorderingProcessor>();
        List2.add(Common.translatedText(key).func_241878_f());
        return List2;
    }
}

