/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.util.Rgb;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

public class DefaultColorButton
extends Button {
    private static final ITextComponent DEFAULT = Common.translatedText("menu.seasonhud.color.default.button");
    private final ColorEditBox colorEditBox;
    private final int defaultColor;

    private DefaultColorButton(int x, int y, ColorEditBox colorEditBox, Button.IPressable onPress) {
        super(x, y, colorEditBox.func_230998_h_() + 2, colorEditBox.func_238483_d_() - 2, DEFAULT, onPress);
        this.colorEditBox = colorEditBox;
        this.defaultColor = colorEditBox.getSeason().getDefaultColor();
    }

    public static Builder builder(ColorEditBox colorEditBox, Button.IPressable onPress) {
        return new Builder(colorEditBox, onPress);
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException var) {
            return false;
        }
    }

    public boolean isHoveredOrFocused() {
        return this.func_230449_g_() || this.func_230999_j_();
    }

    public int getTextureY() {
        int k = 1;
        if (!this.field_230693_o_) {
            k = 0;
        } else if (this.isHoveredOrFocused()) {
            k = 2;
        }
        return 46 + k * 20;
    }

    public void func_230430_a_(@NotNull MatrixStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.refresh();
        String boxValue = this.colorEditBox.func_146179_b();
        if (this.validate(boxValue) && Integer.parseInt(boxValue) == this.defaultColor) {
            this.field_230693_o_ = false;
        }
        super.func_230430_a_(graphics, mouseX, mouseY, partialTicks);
    }

    private void refresh() {
        Map<String, Integer> currentColors;
        Map<String, Integer> defaultColors = Rgb.defaultSeasonMap(this.colorEditBox.getSeason());
        this.field_230693_o_ = defaultColors != (currentColors = this.colorEditBox.getSeason().getRgbMap());
    }

    public static class Builder {
        protected final Button.IPressable onPress;
        protected final ColorEditBox colorEditBox;
        protected int x;
        protected int y;

        public Builder(ColorEditBox colorEditBox, Button.IPressable onPress) {
            this.colorEditBox = colorEditBox;
            this.onPress = onPress;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public DefaultColorButton build() {
            DefaultColorButton button = new DefaultColorButton(this.x, this.y, this.colorEditBox, this.onPress);
            return button;
        }
    }
}

