/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import club.iananderson.seasonhud.Common;
import java.util.List;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;

public class MenuButton
extends Button {
    public static final int SMALL_WIDTH = 120;
    public static final int DEFAULT_WIDTH = 150;
    public static final int DEFAULT_HEIGHT = 20;

    protected MenuButton(int x, int y, int width, int height, MenuButtons buttonType, Button.IPressable onPress) {
        super(x, y, width, height, buttonType.getButtonText(), onPress);
    }

    public static Builder builder(MenuButtons button, Button.IPressable onPress) {
        return new Builder(button, onPress);
    }

    public static enum MenuButtons {
        DONE(DialogTexts.field_240632_c_),
        CANCEL(DialogTexts.field_240633_d_),
        COLORS((ITextComponent)Common.translatedText("menu.seasonhud.main.color.button").func_240702_b_("...")),
        SEASON((ITextComponent)Common.translatedText("menu.seasonhud.main.season.button").func_240702_b_("..."));

        private final ITextComponent buttonText;

        private MenuButtons(ITextComponent buttonText) {
            this.buttonText = buttonText;
        }

        public ITextComponent getButtonText() {
            return this.buttonText;
        }
    }

    public static class Builder {
        protected final MenuButtons buttonType;
        protected final Button.IPressable onPress;
        protected int x;
        protected int y;
        protected int width = 150;
        protected int height = 20;
        protected List<IReorderingProcessor> tooltip;

        public Builder(MenuButtons buttonType, Button.IPressable onPress) {
            this.buttonType = buttonType;
            this.onPress = onPress;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withBounds(int x, int y, int width, int height) {
            this.withPos(x, y);
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withTooltip(List<IReorderingProcessor> tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public MenuButton build() {
            MenuButton button = new MenuButton(this.x, this.y, this.width, this.height, this.buttonType, this.onPress);
            return button;
        }
    }
}

