/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.sliders;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.sliders.BasicSlider;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class HudOffsetSlider
extends BasicSlider {
    protected final ITextComponent prefix;
    private final Supplier<BasicSlider> tooltipSupplier;

    protected HudOffsetSlider(int x, int y, int width, int height, ITextComponent prefix, int initial, int minValue, int maxValue, int defaultValue, Supplier<BasicSlider> tooltipSupplier) {
        super(x, y, width, height, true, initial, minValue, maxValue, defaultValue);
        this.prefix = prefix;
        this.tooltipSupplier = tooltipSupplier;
        this.func_230979_b_();
    }

    public static Builder builder(ITextComponent prefix) {
        return new Builder(prefix);
    }

    @Override
    protected void func_230979_b_() {
        if (this.drawString) {
            this.func_238482_a_((ITextComponent)Common.literalText("").func_230529_a_(this.prefix).func_240702_b_(this.getValueString()));
        } else {
            this.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }
    }

    @Override
    public void func_230441_a_(@NotNull MatrixStack graphics, @NotNull Minecraft mc, int mouseX, int mouseY) {
        super.func_230441_a_(graphics, mc, mouseX, mouseY);
    }

    public static class Builder {
        protected ITextComponent prefix;
        protected int x;
        protected int y;
        protected int width = 180;
        protected int height = 20;
        protected int minValue;
        protected int maxValue;
        protected int initial;
        protected int defaultValue;
        protected Supplier<BasicSlider> tooltipSupplier;

        public Builder(ITextComponent prefix) {
            this.prefix = prefix;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withValueRange(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        public Builder withInitialValue(int initial) {
            this.initial = initial;
            return this;
        }

        public Builder withDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withValues(int minValue, int maxValue, int initial, int defaultValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.defaultValue = defaultValue;
            this.initial = MathHelper.func_76125_a((int)initial, (int)this.minValue, (int)this.maxValue);
            return this;
        }

        public Builder withTooltip(Supplier<BasicSlider> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public HudOffsetSlider build() {
            HudOffsetSlider slider = new HudOffsetSlider(this.x, this.y, this.width, this.height, this.prefix, this.initial, this.minValue, this.maxValue, this.defaultValue, this.tooltipSupplier);
            return slider;
        }
    }
}

