/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.screens;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.buttons.CycleButton;
import club.iananderson.seasonhud.client.gui.components.buttons.MenuButton;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonHudScreen;
import club.iananderson.seasonhud.client.gui.screens.SeasonOptionsScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.jetbrains.annotations.NotNull;

public class MainConfigScreen
extends SeasonHudScreen {
    private static final ITextComponent SCREEN_TITLE = Common.translatedText("menu.seasonhud.main.title");
    private static final ITextComponent MINIMAP_SETTINGS = Common.translatedText("menu.seasonhud.main.minimap.options");
    private static final ITextComponent JOURNEYMAP = Common.translatedText("menu.seasonhud.main.journeymap.title");
    private final List<Widget> optionButtons = new ArrayList<Widget>();
    MenuButton seasonButton;
    MenuButton colorButton;
    CycleButton<Boolean> enableMinimapIntegrationButton;
    CycleButton<Boolean> showMinimapHiddenButton;
    CycleButton<Boolean> journeyMapAboveMapButton;
    CycleButton<Boolean> journeyMapMacOSButton;
    private boolean enableMod;
    private boolean showMinimapHidden;
    private boolean enableMinimapIntegration;
    private boolean journeyMapAboveMap;
    private boolean journeyMapMacOS;

    public MainConfigScreen() {
        super(null, SCREEN_TITLE);
        this.loadConfig();
        this.BUTTON_WIDTH = 170;
    }

    public static MainConfigScreen getInstance() {
        return new MainConfigScreen();
    }

    public void loadConfig() {
        this.enableMod = SeasonHudClient.getEnableMod();
        this.showMinimapHidden = SeasonHudClient.getShowDefaultWhenMinimapHidden();
        this.enableMinimapIntegration = SeasonHudClient.getEnableMinimapIntegration();
        if (CurrentMinimap.journeyMapLoaded()) {
            this.journeyMapAboveMap = SeasonHudClient.getJourneyMapAboveMap();
            this.journeyMapMacOS = SeasonHudClient.getJourneyMapMacOS();
        }
    }

    @Override
    public void saveConfig() {
        SeasonHudClient.setEnableMod(this.enableMod);
        SeasonHudClient.setEnableMinimapIntegration(this.enableMinimapIntegration);
        SeasonHudClient.setShowDefaultWhenMinimapHidden(this.showMinimapHidden);
        if (CurrentMinimap.journeyMapLoaded()) {
            SeasonHudClient.setJourneyMapAboveMap(this.journeyMapAboveMap);
            SeasonHudClient.setJourneyMapMacOS(this.journeyMapMacOS);
        }
    }

    @Override
    public void onDone() {
        this.saveConfig();
        super.onDone();
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
    }

    @Override
    public void func_230430_a_(@NotNull MatrixStack graphics, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(graphics, mouseX, mouseY, partialTicks);
        int n = this.field_230708_k_ / 2;
        Objects.requireNonNull(this.field_230712_o_);
        AbstractGui.func_238472_a_((MatrixStack)graphics, (FontRenderer)this.field_230712_o_, (ITextComponent)MINIMAP_SETTINGS, (int)n, (int)(50 + 2 * (this.BUTTON_HEIGHT + 6) - (9 + 6)), (int)0xFFFFFF);
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            int n2 = this.field_230708_k_ / 2;
            Objects.requireNonNull(this.field_230712_o_);
            AbstractGui.func_238472_a_((MatrixStack)graphics, (FontRenderer)this.field_230712_o_, (ITextComponent)JOURNEYMAP, (int)n2, (int)(50 + 4 * (this.BUTTON_HEIGHT + 6) - (9 + 6)), (int)0xFFFFFF);
            this.journeyMapAboveMapButton.field_230693_o_ = this.enableMod;
            this.journeyMapMacOSButton.field_230693_o_ = this.enableMod;
        }
        this.seasonButton.field_230693_o_ = this.enableMod;
        this.colorButton.field_230693_o_ = this.enableMod;
        this.enableMinimapIntegrationButton.field_230693_o_ = this.enableMod;
        this.showMinimapHiddenButton.field_230693_o_ = this.enableMod;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int enableModWidth = this.field_230712_o_.func_238414_a_((ITextProperties)Common.translatedText("menu.seasonhud.main.enableMod.button").func_240702_b_(": OFF")) + 8;
        CycleButton<Boolean> enableModButton = CycleButton.onOffBuilder(this.enableMod).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.enableMod.tooltip")).create(this.field_230708_k_ - enableModWidth - 5, 5, enableModWidth, this.BUTTON_HEIGHT, (ITextComponent)Common.translatedText("menu.seasonhud.main.enableMod.button"), (b, val) -> {
            this.enableMod = val;
        });
        int row = 0;
        this.seasonButton = MenuButton.builder(MenuButton.MenuButtons.SEASON, b -> {
            this.saveConfig();
            SeasonOptionsScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.season.tooltip")).withPos(this.leftButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        this.colorButton = MenuButton.builder(MenuButton.MenuButtons.COLORS, b -> {
            this.saveConfig();
            ColorScreen.getInstance(this).open();
        }).withTooltip(Common.newTooltip("menu.seasonhud.main.color.tooltip")).withPos(this.rightButtonX, this.buttonStartY + row * this.yOffset).withWidth(this.BUTTON_WIDTH).build();
        row = 2;
        this.enableMinimapIntegrationButton = CycleButton.onOffBuilder(this.enableMinimapIntegration).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.minimapIntegration.tooltip")).create(this.leftButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (ITextComponent)Common.translatedText("menu.seasonhud.main.enableMinimapIntegration.button"), (b, val) -> {
            this.enableMinimapIntegration = val;
        });
        this.showMinimapHiddenButton = CycleButton.onOffBuilder(this.showMinimapHidden).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.showMinimapHidden.tooltip")).create(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (ITextComponent)Common.translatedText("menu.seasonhud.main.showMinimapHidden.button"), (b, val) -> {
            this.showMinimapHidden = val;
        });
        this.widgets.addAll(Arrays.asList(new AbstractButton[]{this.seasonButton, this.colorButton, enableModButton, this.enableMinimapIntegrationButton, this.showMinimapHiddenButton}));
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            this.journeyMapAboveMapButton = CycleButton.onOffBuilder(this.journeyMapAboveMap).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.journeymap.aboveMap.tooltip")).create(this.leftButtonX, this.buttonStartY + (row += 2) * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (ITextComponent)Common.translatedText("menu.seasonhud.main.journeymap.aboveMap.button"), (b, val) -> {
                this.journeyMapAboveMap = val;
            });
            this.journeyMapMacOSButton = CycleButton.onOffBuilder(this.journeyMapMacOS).withTooltip(t -> Common.newTooltip("menu.seasonhud.main.journeymap.macOS.tooltip")).create(this.rightButtonX, this.buttonStartY + row * this.yOffset, this.BUTTON_WIDTH, this.BUTTON_HEIGHT, (ITextComponent)Common.translatedText("menu.seasonhud.main.journeymap.macOS.button"), (b, val) -> {
                this.journeyMapMacOS = val;
            });
            this.widgets.add(this.journeyMapAboveMapButton);
            this.widgets.add(this.journeyMapMacOSButton);
        }
        this.widgets.forEach(x$0 -> this.func_230480_a_((Widget)x$0));
    }
}

