/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class MapAtlasesCommon {
    private MapAtlasesCommon() {
    }

    private static void drawSeasonWithLighterShadow(MatrixStack graphics, FontRenderer font, IFormattableTextComponent text, IFormattableTextComponent shadowText) {
        font.func_243248_b(graphics, (ITextComponent)shadowText, 1.0f, 1.0f, 0x595959);
        font.func_243248_b(graphics, (ITextComponent)text, 0.0f, 0.0f, 0xFFFFFF);
    }

    private static void drawScaledComponent(MatrixStack graphics, FontRenderer font, int x, int y, IFormattableTextComponent text, IFormattableTextComponent shadowText, float textScaling, int maxWidth, int targetWidth) {
        float textWidth = font.func_238414_a_((ITextProperties)text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        graphics.func_227860_a_();
        graphics.func_227861_a_((double)centerX, (double)(y + 4), 5.0);
        graphics.func_227862_a_(scale *= textScaling, scale, 1.0f);
        graphics.func_227861_a_((double)(-textWidth / 2.0f), -4.0, 0.0);
        MapAtlasesCommon.drawSeasonWithLighterShadow(graphics, font, text, shadowText);
        graphics.func_227865_b_();
    }

    public static void drawMapComponentSeason(MatrixStack graphics, FontRenderer font, int x, int y, int targetWidth, float textScaling, float globalScale) {
        IFormattableTextComponent seasonCombined = CurrentSeason.getInstance(Minecraft.func_71410_x()).getHudText();
        IFormattableTextComponent seasonShadowText = CurrentSeason.getInstance(Minecraft.func_71410_x()).getHudTextNoFormat();
        IFormattableTextComponent fertility = CurrentFertility.getInstance(Minecraft.func_71410_x()).getMinimapText();
        IFormattableTextComponent fertilityShadowText = CurrentFertility.getInstance(Minecraft.func_71410_x()).getHudTextNoFormat();
        MapAtlasesCommon.drawScaledComponent(graphics, font, x, y, seasonCombined, seasonShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
            Objects.requireNonNull(font);
            MapAtlasesCommon.drawScaledComponent(graphics, font, x, y + 9, fertility, fertilityShadowText, textScaling / globalScale, targetWidth, (int)((float)targetWidth / globalScale));
        }
    }

    public static void drawScaledText(MatrixStack graphics, int x, int y, IFormattableTextComponent text, IFormattableTextComponent shadowText, float textScaling, int originOffsetWidth, int originOffsetHeight) {
        Minecraft mc = Minecraft.func_71410_x();
        float textWidth = (float)mc.field_71466_p.func_238414_a_((ITextProperties)text) * textScaling;
        float textX = (float)((double)x + (double)originOffsetWidth / 2.0 - (double)textWidth / 2.0);
        float textY = y + originOffsetHeight;
        if (textX + textWidth >= (float)mc.func_228018_at_().func_198107_o()) {
            textX = (float)mc.func_228018_at_().func_198107_o() - textWidth;
        }
        graphics.func_227860_a_();
        graphics.func_227861_a_((double)textX, (double)textY, 5.0);
        graphics.func_227862_a_(textScaling, textScaling, 1.0f);
        mc.field_71466_p.func_243248_b(graphics, (ITextComponent)shadowText, 1.0f, 1.0f, Integer.parseInt("595959", 16));
        mc.field_71466_p.func_243248_b(graphics, (ITextComponent)text, 0.0f, 0.0f, Integer.parseInt("E0E0E0", 16));
        graphics.func_227865_b_();
    }

    public static void drawMapComponentSeasonOld(MatrixStack graphics, int x, int y, int originOffsetWidth, int originOffsetHeight, float textScaling) {
        if (CurrentMinimap.mapAtlasesLoaded()) {
            Minecraft mc = Minecraft.func_71410_x();
            IFormattableTextComponent seasonCombined = CurrentSeason.getInstance(Minecraft.func_71410_x()).getHudText();
            IFormattableTextComponent seasonShadowText = CurrentSeason.getInstance(Minecraft.func_71410_x()).getHudTextNoFormat();
            IFormattableTextComponent fertility = CurrentFertility.getInstance(Minecraft.func_71410_x()).getMinimapText();
            IFormattableTextComponent fertilityShadowText = CurrentFertility.getInstance(Minecraft.func_71410_x()).getHudTextNoFormat();
            MapAtlasesCommon.drawScaledText(graphics, x, y, seasonCombined, seasonShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
                Objects.requireNonNull(mc.field_71466_p);
                MapAtlasesCommon.drawScaledText(graphics, x, y + 9, fertility, fertilityShadowText, textScaling, originOffsetWidth, originOffsetHeight);
            }
        }
    }
}

