/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.forge.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentFertility;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import journeymap.client.JourneymapClient;
import journeymap.client.io.ThemeLoader;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeLabelSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.text.ITextComponent;

public class JourneyMapCommon {
    private final ITextComponent seasonCombined;
    private final ITextComponent fertility;
    private final FontRenderer fontRenderer;
    private final boolean fontShadow;
    private final float fontScale;
    private final float labelAlpha;
    private final float textAlpha;
    private final double textureX;
    private final double textureY;
    private final int minimapHeight;
    private final int halfWidth;
    private final int margin;
    private final int labelColor;
    private final int textColor;
    private final int labelHeight;
    private final int topLabelHeight;
    private final int bottomLabelHeight;
    private final double scaledWidth;
    private final double scaledHeight;
    private double screenWidth;
    private double screenHeight;

    public JourneyMapCommon(Minecraft mc) {
        int minimapWidth;
        this.fontRenderer = mc.field_71466_p;
        this.seasonCombined = CurrentSeason.getInstance(mc).getHudText();
        this.fertility = CurrentFertility.getInstance(mc).getMinimapText();
        JourneymapClient jm = JourneymapClient.getInstance();
        DisplayVars vars = UIManager.INSTANCE.getMiniMap().getDisplayVars();
        MiniMapProperties mapProperties = jm.getActiveMiniMapProperties();
        Theme.LabelSpec currentTheme = ThemeLoader.getCurrentTheme().minimap.square.labelBottom;
        this.fontShadow = currentTheme.shadow;
        this.fontScale = jm.getActiveMiniMapProperties().fontScale.get().floatValue();
        this.labelAlpha = jm.getActiveMiniMapProperties().infoSlotAlpha.get().floatValue();
        this.textAlpha = currentTheme.foreground.alpha;
        this.textureX = vars.textureX;
        this.textureY = vars.textureY;
        this.minimapHeight = minimapWidth = vars.minimapWidth;
        this.halfWidth = minimapWidth / 2;
        this.margin = ThemeLoader.getCurrentTheme().minimap.square.margin;
        this.labelColor = currentTheme.background.getColor();
        this.textColor = currentTheme.foreground.getColor();
        this.labelHeight = (int)((float)(DrawUtil.getLabelHeight((FontRenderer)this.fontRenderer, (boolean)this.fontShadow) + currentTheme.margin) * this.fontScale);
        this.topLabelHeight = vars.getInfoLabelAreaHeight(this.fontRenderer, currentTheme, new ThemeLabelSource.InfoSlot[]{(ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info1Label.get()), (ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info2Label.get())});
        this.bottomLabelHeight = vars.getInfoLabelAreaHeight(this.fontRenderer, currentTheme, new ThemeLabelSource.InfoSlot[]{(ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info3Label.get()), (ThemeLabelSource.InfoSlot)ThemeLabelSource.values.get(mapProperties.info4Label.get())});
        this.screenWidth = mc.func_228018_at_().func_198109_k();
        this.screenHeight = mc.func_228018_at_().func_198091_l();
        if (SeasonHudClient.getJourneyMapMacOS()) {
            this.screenWidth /= 2.0;
            this.screenHeight /= 2.0;
        }
        double guiScale = mc.func_228018_at_().func_198100_s();
        this.scaledWidth = this.screenWidth / guiScale;
        this.scaledHeight = this.screenHeight / guiScale;
    }

    public static JourneyMapCommon getInstance(Minecraft mc) {
        return new JourneyMapCommon(mc);
    }

    private int labelX() {
        return (int)(this.textureX + (double)this.halfWidth);
    }

    private int labelY() {
        int startY = (int)(this.textureY + (double)(SeasonHudClient.getJourneyMapAboveMap() ? 0 : (SeasonHudClient.getJourneyMapMacOS() ? -this.margin - this.labelHeight : this.minimapHeight + this.margin)));
        return startY + (SeasonHudClient.getJourneyMapAboveMap() ? -this.topLabelHeight - this.margin - this.labelHeight : this.bottomLabelHeight);
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public double getScreenWidth() {
        return this.screenWidth;
    }

    public double getScreenHeight() {
        return this.screenHeight;
    }

    public void drawSeasonLabel(MatrixStack graphics) {
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        buffers.func_228461_a_();
        DrawUtil.drawLabel((MatrixStack)graphics, (ITextComponent)this.seasonCombined, (double)this.labelX(), (double)this.labelY(), (DrawUtil.HAlign)DrawUtil.HAlign.Center, (DrawUtil.VAlign)DrawUtil.VAlign.Below, (Integer)this.labelColor, (float)this.labelAlpha, (int)this.textColor, (float)this.textAlpha, (double)this.fontScale, (boolean)this.fontShadow);
        if (Common.sereneSeasonsLoaded() && SeasonHudClient.getShowFertility()) {
            double d = this.labelX();
            float f = this.labelY();
            Objects.requireNonNull(this.fontRenderer);
            DrawUtil.drawLabel((MatrixStack)graphics, (ITextComponent)this.fertility, (double)d, (double)(f + 9.0f * this.fontScale + (float)this.margin), (DrawUtil.HAlign)DrawUtil.HAlign.Center, (DrawUtil.VAlign)DrawUtil.VAlign.Below, (Integer)this.labelColor, (float)this.labelAlpha, (int)this.textColor, (float)this.textAlpha, (double)this.fontScale, (boolean)this.fontShadow);
        }
        buffers.func_228461_a_();
        DrawUtil.sizeDisplay((double)this.scaledWidth, (double)this.scaledHeight);
    }
}

