/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.forge.mixin.voxel;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Map.class})
public class VoxelMapMixin {
    @Shadow
    private int mapX;
    @Shadow
    private int mapY;
    @Shadow
    private int scHeight;
    @Shadow
    private MapSettingsManager options;
    @Shadow
    private String error;
    @Shadow
    private boolean fullscreenMap;
    @Shadow
    private Minecraft game;
    @Shadow
    private FontRenderer fontRenderer;

    @Shadow
    private int chkLen(ITextComponent text) {
        return this.fontRenderer.func_238414_a_((ITextProperties)text);
    }

    @Shadow
    private void write(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        this.fontRenderer.func_243246_a(matrixStack, text, x, y, color);
    }

    @Unique
    private void seasonhud$showSeason(MatrixStack graphics, int x, int y) {
        int textStart;
        if (y > this.scHeight - 37 - 32 - 4 - 15) {
            textStart = y - 32 - 4 - 9;
            if (this.options.coords) {
                textStart -= 5;
            }
        } else {
            textStart = y + 32 + 4;
            if (this.options.coords) {
                textStart += 10;
            }
            if (!this.error.isEmpty()) {
                textStart += 5;
            }
        }
        if (!this.options.hide && !this.fullscreenMap) {
            boolean unicode = this.game.field_71474_y.field_211842_aO;
            float scale = unicode ? 1.0f : 0.5f;
            GLShim.glPushMatrix();
            GLShim.glScalef((float)scale, (float)scale, (float)1.0f);
            IFormattableTextComponent seasonCombined = CurrentSeason.getInstance(this.game).getHudText();
            int m = this.chkLen((ITextComponent)seasonCombined) / 2;
            this.write(graphics, (ITextComponent)seasonCombined, (float)x / scale - (float)m, (float)textStart / scale, 0xFFFFFF);
            GLShim.glPopMatrix();
        }
    }

    @Inject(method={"drawMinimap"}, at={@At(value="INVOKE", target="Lcom/mamiyaotaru/voxelmap/Map;showCoords(Lcom/mojang/blaze3d/vertex/PoseStack;II)V", shift=At.Shift.BY, by=2)})
    private void drawMinimap(MatrixStack matrixStack, Minecraft mc, CallbackInfo ci) {
        if (SeasonHudClient.getEnableMod() && SeasonHudClient.getEnableMinimapIntegration() && CurrentMinimap.shouldDrawMinimapHud(CurrentMinimap.Minimap.VOXELMAP)) {
            this.seasonhud$showSeason(matrixStack, this.mapX, this.mapY);
        }
    }
}

