/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.Fertility;
import club.iananderson.seasonhud.impl.seasons.mods.ISeasonModHelper;
import club.iananderson.seasonhud.platform.Services;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.SeasonsConfig;

public class SereneSeasonsHelper
implements ISeasonModHelper {
    @Override
    public Item CALENDAR() {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation("sereneseasons", "calendar"));
    }

    @Override
    public boolean isTropicalSeason(PlayerEntity player) {
        return Services.PLATFORM.sereneSeasonTropicalBiome(player);
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        return false;
    }

    @Override
    public String getCurrentSubSeason(PlayerEntity player) {
        return Services.PLATFORM.getCurrentSereneSubSeason(player);
    }

    @Override
    public String getCurrentSeason(PlayerEntity player) {
        return Services.PLATFORM.getCurrentSereneSeason(player);
    }

    @Override
    public long getDate(PlayerEntity player) {
        return Services.PLATFORM.getSereneSeasonDate(player);
    }

    @Override
    public int seasonDuration(PlayerEntity player) {
        int duration = (Integer)SeasonsConfig.subSeasonDuration.get() * 3;
        if (this.isTropicalSeason(player)) {
            duration *= 2;
        }
        if (SeasonHudClient.getShowSubSeason() && Calendar.validDetailedMode()) {
            duration /= 3;
        }
        return duration;
    }

    @Override
    public boolean infertileBiome(PlayerEntity player) {
        if (!((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() || !Services.PLATFORM.sereneSeasonBiomeSeasonalEffects(player) || Services.MINIMAP.hideHudInCurrentDimension()) {
            return false;
        }
        return Services.PLATFORM.sereneSeasonInfertileBiome(player);
    }

    @Override
    public boolean alwaysWinterBiome(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean undergroundFertile(PlayerEntity player) {
        World level = player.field_70170_p;
        BlockPos pos = player.func_233580_cy_();
        if (!((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() || !Services.PLATFORM.sereneSeasonBiomeSeasonalEffects(player) || Services.MINIMAP.hideHudInCurrentDimension()) {
            return true;
        }
        if (!level.func_226660_f_(pos.func_177984_a())) {
            return pos.func_177956_o() > (Integer)FertilityConfig.undergroundFertilityLevel.get();
        }
        return true;
    }

    @Override
    public Fertility fertility(PlayerEntity player) {
        if (this.infertileBiome(player)) {
            return Fertility.INFERTILE_BIOME;
        }
        if (this.alwaysWinterBiome(player)) {
            return Fertility.ALWAYS_WINTER;
        }
        if (!this.undergroundFertile(player)) {
            return Fertility.UNDERGROUND;
        }
        return Fertility.FERTILE;
    }
}

