/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons.mods;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudServer;
import club.iananderson.seasonhud.impl.seasons.mods.IModHelper;
import io.github.lucaargolo.seasons.FabricSeasons;
import io.github.lucaargolo.seasons.utils.Season;
import java.time.LocalDateTime;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class FabricSeasonsHelper
implements IModHelper {
    @Override
    public Item CALENDAR() {
        if (Common.fabricSeasonsLoaded()) {
            return (Item)Registry.f_122827_.m_7745_(new ResourceLocation("seasons", "season_calendar"));
        }
        return null;
    }

    @Override
    public boolean isTropicalSeason(Player player) {
        return false;
    }

    @Override
    public boolean isSeasonTiedWithSystemTime() {
        if (Common.fabricSeasonsLoaded()) {
            return FabricSeasons.CONFIG.isSeasonTiedWithSystemTime();
        }
        return false;
    }

    @Override
    public String getCurrentSubSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.f_19853_);
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public String getCurrentSeason(Player player) {
        Season currentSeasonState = FabricSeasons.getCurrentSeason((Level)player.f_19853_);
        if (currentSeasonState.toString().equalsIgnoreCase("fall")) {
            return "Autumn";
        }
        return currentSeasonState.toString();
    }

    @Override
    public long getDate(Player player) {
        long dayLength = SeasonHudServer.getDayLength();
        long seasonLength = FabricSeasons.CONFIG.getSeasonLength();
        long worldTime = player.f_19853_.m_46468_();
        if (this.isSeasonTiedWithSystemTime()) {
            return LocalDateTime.now().getDayOfMonth();
        }
        return (worldTime - worldTime / seasonLength * seasonLength) % seasonLength / dayLength + 1L;
    }

    @Override
    public int seasonDuration(Player player) {
        int dayLength = SeasonHudServer.getDayLength();
        return FabricSeasons.CONFIG.getSeasonLength() / dayLength;
    }
}

