/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.overlays;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SeasonHUDOverlayCommon {
    private SeasonHUDOverlayCommon() {
    }

    public static void render(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        if (Common.drawDefaultHud() && Common.vanillaShouldDrawHud() && Calendar.validNeedCalendar() && !Common.hideHudInCurrentDimension()) {
            int screenWidth = mc.getWindow().getGuiScaledWidth();
            int screenHeight = mc.getWindow().getGuiScaledHeight();
            int x = 0;
            int y = 0;
            int xOffset = SeasonHudClient.getHudX();
            int yOffset = SeasonHudClient.getHudY();
            double scale = SeasonHudClient.getHudScale();
            int DEFAULT_X_OFFSET = 2;
            int DEFAULT_Y_OFFSET = 2;
            MutableComponent seasonCombined = CurrentSeason.getInstance(mc).getSeasonHudText();
            int stringWidth = (int)((double)mc.font.width((FormattedText)seasonCombined) * scale);
            Objects.requireNonNull(mc.font);
            int stringHeight = (int)(9.0 * scale);
            switch (SeasonHudClient.getHudLocation()) {
                case TOP_LEFT: {
                    x = DEFAULT_X_OFFSET;
                    y = DEFAULT_Y_OFFSET;
                    break;
                }
                case TOP_CENTER: {
                    x = (int)(((double)screenWidth / 2.0 - (double)stringWidth / 2.0) / scale);
                    y = DEFAULT_Y_OFFSET;
                    break;
                }
                case TOP_RIGHT: {
                    x = (int)((double)(screenWidth - stringWidth - DEFAULT_X_OFFSET) / scale);
                    y = DEFAULT_Y_OFFSET;
                    break;
                }
                case BOTTOM_LEFT: {
                    x = DEFAULT_X_OFFSET;
                    y = (int)((double)(screenHeight - stringHeight - DEFAULT_Y_OFFSET) / scale);
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = (int)((double)(screenWidth - stringWidth - DEFAULT_X_OFFSET) / scale);
                    y = (int)((double)(screenHeight - stringHeight - DEFAULT_Y_OFFSET) / scale);
                    break;
                }
                case CUSTOM: {
                    x = xOffset;
                    y = yOffset;
                }
            }
            graphics.pose().pushMatrix();
            graphics.pose().scale((float)scale, (float)scale);
            graphics.drawString(mc.font, (Component)seasonCombined, x, y, -1);
            graphics.pose().popMatrix();
        }
    }
}

