/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud;

import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import club.iananderson.seasonhud.platform.Services;
import com.demonwav.mcdev.annotations.Translatable;
import io.github.lucaargolo.seasons.FabricSeasons;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sereneseasons.config.ServerConfig;

public class Common {
    public static final String MOD_ID = "seasonhud";
    public static final String MOD_NAME = "SeasonHUD";
    public static final Logger LOG = LoggerFactory.getLogger((String)"SeasonHUD");
    public static final ResourceLocation SEASON_ICONS = Common.location("season_icons");
    public static final Style SEASON_ICON_STYLE = Style.f_131099_.m_131150_(SEASON_ICONS);
    public static ResourceLocation slotIcon = new ResourceLocation("seasonhud", "slot/calendarslot");
    private static String platformName;
    private static boolean sereneSeasonsLoaded;
    private static boolean fabricSeasonsLoaded;
    private static boolean fabricSeasonsExtrasLoaded;
    private static boolean terrafirmacraftLoaded;
    private static boolean eclipticSeasonsLoaded;
    private static boolean curiosLoaded;
    private static boolean trinketsLoaded;
    private static boolean accessoriesLoaded;

    private Common() {
    }

    public static void init() {
        platformName = Services.PLATFORM.getPlatformName();
        sereneSeasonsLoaded = Services.PLATFORM.isModLoaded("sereneseasons");
        fabricSeasonsLoaded = Services.PLATFORM.isModLoaded("seasons");
        fabricSeasonsExtrasLoaded = Services.PLATFORM.isModLoaded("seasonsextras");
        terrafirmacraftLoaded = Services.PLATFORM.isModLoaded("tfc");
        eclipticSeasonsLoaded = Services.PLATFORM.isModLoaded("eclipticseasons");
        curiosLoaded = Services.PLATFORM.isModLoaded("curios");
        trinketsLoaded = Services.PLATFORM.isModLoaded("trinkets");
        accessoriesLoaded = Services.PLATFORM.isModLoaded("accessories");
    }

    public static String platformName() {
        return platformName;
    }

    public static boolean sereneSeasonsLoaded() {
        return sereneSeasonsLoaded;
    }

    public static boolean fabricSeasonsLoaded() {
        return fabricSeasonsLoaded;
    }

    public static boolean fabricSeasonsExtrasLoaded() {
        return fabricSeasonsExtrasLoaded;
    }

    public static boolean terrafirmacraftLoaded() {
        return terrafirmacraftLoaded;
    }

    public static boolean eclipticSeasonsLoaded() {
        return eclipticSeasonsLoaded;
    }

    public static boolean curiosLoaded() {
        return curiosLoaded;
    }

    public static boolean trinketsLoaded() {
        return trinketsLoaded;
    }

    public static boolean accessoriesLoaded() {
        return accessoriesLoaded;
    }

    public static boolean hasCalendarLoaded() {
        return Common.fabricSeasonsExtrasLoaded() || Common.sereneSeasonsLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean hasSubSeasons() {
        return Common.sereneSeasonsLoaded() || Common.terrafirmacraftLoaded() || Common.eclipticSeasonsLoaded();
    }

    public static boolean clientSideConfig() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.m_91089_() == null;
    }

    public static boolean vanillaShouldDrawHud() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        return (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen || mc.f_91080_ instanceof DeathScreen) && !mc.f_91066_.f_92063_ && !mc.f_91066_.f_92062_ && !mc.f_91074_.m_150108_();
    }

    public static boolean minimapIntegrationHidden() {
        return SeasonHudClient.getEnableMinimapIntegration() && CurrentMinimap.allMinimapsHidden() && SeasonHudClient.getShowDefaultWhenMinimapHidden();
    }

    public static boolean drawDefaultHud() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || Common.minimapIntegrationHidden());
    }

    public static boolean drawDefaultHudMenu() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        return SeasonHudClient.getEnableMod() && (CurrentMinimap.noMinimapLoaded() || !SeasonHudClient.getEnableMinimapIntegration() || SeasonHudClient.getShowDefaultWhenMinimapHidden());
    }

    public static boolean isDimensionValid(List<? extends String> validDimensions, ResourceKey<Level> dimension) {
        for (String string : validDimensions) {
            if (!dimension.m_135782_().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hideHudInCurrentDimension() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        ResourceKey currentDim = Objects.requireNonNull(mc.f_91073_).m_46472_();
        if (Common.fabricSeasonsLoaded()) {
            return !FabricSeasons.CONFIG.isValidInDimension(currentDim);
        }
        if (Common.sereneSeasonsLoaded()) {
            return !ServerConfig.isDimensionWhitelisted((ResourceKey)currentDim);
        }
        if (Common.eclipticSeasonsLoaded()) {
            List<String> validDimensions = List.of(Level.f_46428_.m_135782_().toString());
            return !Common.isDimensionValid(validDimensions, (ResourceKey<Level>)currentDim);
        }
        return false;
    }

    public static boolean allTrue(List<Boolean> values) {
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static MutableComponent literalText(String text) {
        return Component.m_237113_((String)text);
    }

    public static MutableComponent translatedText(@Translatable(foldMethod=true) String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent translatedText(@Translatable(foldMethod=true) String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static List<FormattedCharSequence> newTooltip(@Translatable(foldMethod=true) String key) {
        ArrayList<FormattedCharSequence> List2 = new ArrayList<FormattedCharSequence>();
        List2.add(Common.translatedText(key).m_7532_());
        return List2;
    }
}

