/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.buttons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.components.boxes.ColorEditBox;
import club.iananderson.seasonhud.util.Rgb;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DefaultColorButton
extends Button {
    private static final Component DEFAULT = Common.translatedText("menu.seasonhud.color.default.button");
    private final ColorEditBox colorEditBox;
    private final int defaultColor;

    private DefaultColorButton(int x, int y, ColorEditBox colorEditBox, Button.OnPress onPress) {
        super(x, y, colorEditBox.m_5711_() + 2, colorEditBox.m_93694_() - 2, DEFAULT, onPress);
        this.colorEditBox = colorEditBox;
        this.defaultColor = colorEditBox.getSeason().getDefaultColor();
    }

    public static Builder builder(ColorEditBox colorEditBox, Button.OnPress onPress) {
        return new Builder(colorEditBox, onPress);
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException var) {
            return false;
        }
    }

    public int getTextureY() {
        int k = 1;
        if (!this.f_93623_) {
            k = 0;
        } else if (this.m_198029_()) {
            k = 2;
        }
        return 46 + k * 20;
    }

    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.refresh();
        String boxValue = this.colorEditBox.m_94155_();
        if (this.validate(boxValue) && Integer.parseInt(boxValue) == this.defaultColor) {
            this.f_93623_ = false;
        }
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
    }

    private void refresh() {
        Map<String, Integer> currentColors;
        Map<String, Integer> defaultColors = Rgb.defaultSeasonMap(this.colorEditBox.getSeason());
        this.f_93623_ = defaultColors != (currentColors = this.colorEditBox.getSeason().getRgbMap());
    }

    public static class Builder {
        protected final Button.OnPress onPress;
        protected final ColorEditBox colorEditBox;
        protected int x;
        protected int y;

        public Builder(ColorEditBox colorEditBox, Button.OnPress onPress) {
            this.colorEditBox = colorEditBox;
            this.onPress = onPress;
        }

        public Builder withPos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public DefaultColorButton build() {
            DefaultColorButton button = new DefaultColorButton(this.x, this.y, this.colorEditBox, this.onPress);
            return button;
        }
    }
}

