/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.boxes;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class ColorEditBox
extends EditBox {
    private static final int PADDING = 4;
    private final Seasons boxSeason;
    private final int seasonColor;
    private int newSeasonColor;

    public ColorEditBox(Font font, int x, int y, int width, int height, Seasons season) {
        super(font, x, y, width, height, season.getSeasonName());
        this.boxSeason = season;
        this.newSeasonColor = this.seasonColor = season.getSeasonColor();
        this.setMaxLength(8);
        this.setValue(String.valueOf(this.seasonColor));
        this.setResponder(colorString -> {
            if (this.validate((String)colorString)) {
                this.setTextColor(-1);
                int colorInt = Integer.parseInt(colorString);
                if (colorInt != this.newSeasonColor) {
                    this.newSeasonColor = colorInt;
                    this.setValue((String)colorString);
                }
                ColorScreen.doneButton.active = true;
            } else {
                this.setTextColor(0xFF5555);
                ColorScreen.doneButton.active = false;
            }
        });
        this.setEditable(SeasonHudClient.getEnableSeasonNameColor());
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }

    public void save() {
        Rgb.setRgb(this.boxSeason, this.newSeasonColor);
        this.boxSeason.setSeasonColor(this.newSeasonColor);
    }

    public int getColor() {
        return this.seasonColor;
    }

    public int getNewColor() {
        return this.newSeasonColor;
    }

    public Seasons getSeason() {
        return this.boxSeason;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int widgetTotalSize;
        Minecraft mc = Minecraft.getInstance();
        float textScale = 1.0f;
        int scaledWidth = mc.getWindow().getGuiScaledWidth();
        boolean seasonShort = scaledWidth < (widgetTotalSize = 86 * ColorEditBox.seasonListSet().size());
        MutableComponent seasonCombined = CurrentSeason.getInstance(mc).getSeasonMenuText(this.boxSeason, this.newSeasonColor, seasonShort);
        graphics.pose().pushMatrix();
        if (mc.font.width((FormattedText)seasonCombined) > this.getWidth() - 4) {
            textScale = ((float)this.getWidth() - 4.0f) / (float)mc.font.width((FormattedText)seasonCombined);
        }
        graphics.pose().scale(textScale, textScale);
        Font font = mc.font;
        int n = (int)(((double)this.getX() + (double)this.getWidth() / 2.0) / (double)textScale);
        float f = this.getY();
        Objects.requireNonNull(mc.font);
        graphics.drawCenteredString(font, (Component)seasonCombined, n, (int)((f - 9.0f * textScale - 4.0f) / textScale), -1);
        graphics.pose().popMatrix();
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }
}

