/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.impl.seasons;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.ShowDay;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.Calendar;
import club.iananderson.seasonhud.impl.seasons.CommonSeasonHelper;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import java.time.LocalDateTime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public class CurrentSeason {
    private final String currentSeason;
    private final String currentSubSeason;
    private final String seasonFileName;
    private final long seasonDate;
    private final int seasonDuration;
    private Style seasonFormat;

    public CurrentSeason(Minecraft mc) {
        LocalPlayer player = mc.player;
        this.seasonFormat = Style.EMPTY;
        this.currentSeason = CommonSeasonHelper.commonSeasons.getCurrentSeason((Player)player);
        this.currentSubSeason = CommonSeasonHelper.commonSeasons.getCurrentSubSeason((Player)player);
        this.seasonFileName = CommonSeasonHelper.commonSeasons.getSeasonFileName((Player)player);
        this.seasonDate = CommonSeasonHelper.commonSeasons.getDate((Player)player);
        this.seasonDuration = CommonSeasonHelper.commonSeasons.seasonDuration((Player)player);
    }

    public static CurrentSeason getInstance(Minecraft mc) {
        return new CurrentSeason(mc);
    }

    public String getSubSeasonLowerCase() {
        String lowerSubSeason = this.currentSubSeason.toLowerCase();
        if (Common.fabricSeasonsLoaded()) {
            return this.currentSeason.toLowerCase();
        }
        return this.currentSeason.toLowerCase() + "." + lowerSubSeason.substring(0, lowerSubSeason.indexOf("_"));
    }

    public String getSeasonLowerCase() {
        return this.currentSeason.toLowerCase();
    }

    public Component getSeasonKey(boolean showSubSeason) {
        String season;
        String string = season = showSubSeason ? this.getSubSeasonLowerCase() : this.getSeasonLowerCase();
        if (!Calendar.validDetailedMode() || Common.fabricSeasonsLoaded()) {
            season = this.getSeasonLowerCase();
        }
        if (Common.eclipticSeasonsLoaded() && Calendar.validDetailedMode() && SeasonHudClient.getShowSubSeason()) {
            season = this.currentSubSeason;
            if (this.currentSubSeason.equals("MID_NULL")) {
                return Common.translatedText("desc.seasonhud.season." + this.getSubSeasonLowerCase());
            }
            return Common.translatedText("info.eclipticseasons.environment.solar_term." + season);
        }
        return Common.translatedText("desc.seasonhud.season." + season);
    }

    public String getSeasonIcon() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getIconChar();
        }
        return "Icon Error";
    }

    public Component getText(ShowDay showDay, boolean showSubSeason) {
        MutableComponent text = Common.literalText("");
        Component seasonKey = this.getSeasonKey(showSubSeason);
        switch (showDay) {
            case NONE: {
                text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                break;
            }
            case SHOW_DAY: {
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
                break;
            }
            case SHOW_WITH_TOTAL_DAYS: {
                text = Common.translatedText(ShowDay.SHOW_WITH_TOTAL_DAYS.getKey(), seasonKey, this.seasonDate, this.seasonDuration);
                break;
            }
            case SHOW_WITH_MONTH: {
                if (CommonSeasonHelper.commonSeasons.isSeasonTiedWithSystemTime()) {
                    int systemMonth = LocalDateTime.now().getMonth().getValue();
                    Object systemMonthString = String.valueOf(systemMonth);
                    if (systemMonth < 10) {
                        systemMonthString = "0" + (String)systemMonthString;
                    }
                    MutableComponent currentMonth = Common.translatedText("desc.seasonhud.month." + (String)systemMonthString);
                    text = Common.translatedText(ShowDay.SHOW_WITH_MONTH.getKey(), seasonKey, currentMonth, this.seasonDate);
                    if (Calendar.validDetailedMode()) break;
                    text = Common.translatedText(ShowDay.NONE.getKey(), seasonKey);
                    break;
                }
                text = Common.translatedText(ShowDay.SHOW_DAY.getKey(), seasonKey, this.seasonDate);
            }
        }
        return text;
    }

    public int getTextColor() {
        for (Seasons season : Seasons.values()) {
            if (!season.getFileName().equals(this.seasonFileName)) continue;
            return season.getSeasonColor();
        }
        return 0xFFFFFF;
    }

    public MutableComponent getSeasonHudTextNoFormat() {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon()).withStyle(Common.SEASON_ICON_STYLE);
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        MutableComponent seasonText = this.getText(showDay, showSubSeason).copy();
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon, seasonText);
    }

    public MutableComponent getSeasonHudText() {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon());
        ShowDay showDay = SeasonHudClient.getShowDay();
        boolean showSubSeason = SeasonHudClient.getShowSubSeason();
        MutableComponent seasonText = this.getText(showDay, showSubSeason).copy();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.EMPTY.withColor(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.withStyle(Common.SEASON_ICON_STYLE).withColor(-1), seasonText.withStyle(this.seasonFormat));
    }

    public MutableComponent getSeasonMenuText(Seasons season, int newRgb, boolean seasonShort) {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", season.getIconChar());
        MutableComponent seasonText = Common.translatedText(ShowDay.NONE.getKey(), season.getSeasonName());
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.EMPTY.withColor(newRgb);
        }
        if (season == Seasons.DRY && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.dry.editbox");
        }
        if (season == Seasons.WET && seasonShort) {
            seasonText = Common.translatedText("menu.seasonhud.color.season.wet.editbox");
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.withStyle(Common.SEASON_ICON_STYLE), seasonText.withStyle(this.seasonFormat));
    }

    public MutableComponent getSeasonHudConfigText(ShowDay showDay, boolean showSubSeason) {
        MutableComponent seasonIcon = Common.translatedText("desc.seasonhud.hud.icon", this.getSeasonIcon());
        MutableComponent seasonText = this.getText(showDay, showSubSeason).copy();
        if (SeasonHudClient.getEnableSeasonNameColor()) {
            this.seasonFormat = Style.EMPTY.withColor(this.getTextColor());
        }
        return Common.translatedText("desc.seasonhud.hud.combined", seasonIcon.withStyle(Common.SEASON_ICON_STYLE), seasonText.withStyle(this.seasonFormat));
    }
}

