/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenhopper.inventory;

import de.cech12.woodenhopper.Constants;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WoodenHopperContainer
extends AbstractContainerMenu {
    private final Container hopper;

    public WoodenHopperContainer(int id, Inventory playerInventory, Container inventory) {
        super(Constants.WOODEN_HOPPER_MENU_TYPE.get(), id);
        this.hopper = inventory;
        WoodenHopperContainer.checkContainerSize((Container)inventory, (int)1);
        inventory.startOpen((ContainerUser)playerInventory.player);
        this.addSlot(new Slot(inventory, 0, 80, 20));
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 51));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 109));
        }
    }

    public WoodenHopperContainer(int id, Inventory playerInventoryIn) {
        this(id, playerInventoryIn, (Container)new SimpleContainer(1));
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return this.hopper.stillValid(playerIn);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.hopper.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.hopper.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.hopper.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.hopper.stopOpen((ContainerUser)playerIn);
    }
}

