/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenhopper.platform;

import de.cech12.woodenhopper.Constants;
import de.cech12.woodenhopper.block.WoodenHopperBlock;
import de.cech12.woodenhopper.blockentity.ForgeWoodenHopperBlockEntity;
import de.cech12.woodenhopper.blockentity.WoodenHopperBlockEntity;
import de.cech12.woodenhopper.inventory.WoodenHopperContainer;
import de.cech12.woodenhopper.item.WoodenHopperItem;
import de.cech12.woodenhopper.platform.services.IRegistryHelper;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ForgeRegistryHelper
implements IRegistryHelper {
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES;

    private static RegistryObject<Item> fromBlock(String name, RegistryObject<Block> block) {
        return ITEMS.register(block.getId().getPath(), () -> new WoodenHopperItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.id(name)))));
    }

    @Override
    public WoodenHopperBlockEntity getNewBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ForgeWoodenHopperBlockEntity(pos, state);
    }

    static {
        RegistryObject block;
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"woodenhopper");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"woodenhopper");
        BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"woodenhopper");
        MENU_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.MENU_TYPES, (String)"woodenhopper");
        Constants.WOODEN_HOPPER_BLOCK = block = BLOCKS.register("wooden_hopper", () -> new WoodenHopperBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.5f).sound(SoundType.WOOD).noOcclusion().setId(ResourceKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)Constants.id("wooden_hopper")))));
        Constants.WOODEN_HOPPER_ITEM = ForgeRegistryHelper.fromBlock("wooden_hopper", (RegistryObject<Block>)block);
        Constants.WOODEN_HOPPER_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("wooden_hopper", () -> new BlockEntityType(ForgeWoodenHopperBlockEntity::new, Set.of(Constants.WOODEN_HOPPER_BLOCK.get())));
        Constants.WOODEN_HOPPER_MENU_TYPE = MENU_TYPES.register("woodenhopper", () -> IForgeMenuType.create((pWindowID, pInventory, pData) -> new WoodenHopperContainer(pWindowID, pInventory)));
    }
}

