/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenhopper.platform;

import de.cech12.woodenhopper.Constants;
import de.cech12.woodenhopper.platform.services.IConfigHelper;
import de.cech12.woodenhopper.platform.services.IPlatformHelper;
import de.cech12.woodenhopper.platform.services.IRegistryHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IConfigHelper CONFIG = Services.load(IConfigHelper.class);
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IRegistryHelper REGISTRY = Services.load(IRegistryHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    private Services() {
    }
}

