/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.currency;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.Logger;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PaperCurrency {
    private final EasyShopGUI plugin;
    private final Map<String, CurrencyData> issuedCheques = new ConcurrentHashMap<String, CurrencyData>();
    private final Map<UUID, Long> lastWithdrawTime = new ConcurrentHashMap<UUID, Long>();
    private final SecureRandom random = new SecureRandom();
    private final NamespacedKey CHEQUE_ID_KEY;
    private final NamespacedKey CHEQUE_AMOUNT_KEY;
    private final NamespacedKey CHEQUE_ISSUER_KEY;
    private final NamespacedKey CHEQUE_TIMESTAMP_KEY;
    private final NamespacedKey CHEQUE_SIGNATURE_KEY;

    public PaperCurrency(EasyShopGUI plugin) {
        this.plugin = plugin;
        this.CHEQUE_ID_KEY = new NamespacedKey((Plugin)plugin, "cheque_id");
        this.CHEQUE_AMOUNT_KEY = new NamespacedKey((Plugin)plugin, "cheque_amount");
        this.CHEQUE_ISSUER_KEY = new NamespacedKey((Plugin)plugin, "cheque_issuer");
        this.CHEQUE_TIMESTAMP_KEY = new NamespacedKey((Plugin)plugin, "cheque_timestamp");
        this.CHEQUE_SIGNATURE_KEY = new NamespacedKey((Plugin)plugin, "cheque_signature");
    }

    public boolean withdrawCheque(Player player, double amount) {
        long timeDiff;
        if (amount <= 0.0) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Amount must be positive!");
            return false;
        }
        if (amount > 1000000.0) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Maximum cheque amount is $1,000,000!");
            return false;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastWithdrawTime.containsKey(playerId) && (timeDiff = currentTime - this.lastWithdrawTime.get(playerId)) < 2000L) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Please wait before withdrawing another cheque!");
            return false;
        }
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)player);
        if (balance < amount) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Insufficient funds! You have $" + String.format("%.2f", balance));
            return false;
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.sendMessage("\u00a7c\ud83d\udce6 Your inventory is full!");
            return false;
        }
        String chequeId = this.generateSecureChequeId();
        String signature = this.generateSignature(chequeId, amount, player.getUniqueId().toString());
        this.plugin.getEconomyManager().getEconomy().withdrawPlayer((OfflinePlayer)player, amount);
        ItemStack cheque = this.createChequeItem(chequeId, amount, player, signature);
        CurrencyData data = new CurrencyData(chequeId, amount, player.getUniqueId(), LocalDateTime.now(), signature, false);
        this.issuedCheques.put(chequeId, data);
        player.getInventory().addItem(new ItemStack[]{cheque});
        this.lastWithdrawTime.put(playerId, currentTime);
        player.sendMessage("\u00a7a\ud83d\udcb0 Successfully withdrew $" + String.format("%.2f", amount) + " as a cheque!");
        player.sendMessage("\u00a7e\ud83d\udcc4 Cheque ID: \u00a7f" + chequeId.substring(0, 8) + "...");
        player.sendMessage("\u00a77\ud83d\udca1 Right-click the cheque to redeem it!");
        Logger.info("Player " + player.getName() + " withdrew $" + amount + " as cheque " + chequeId);
        return true;
    }

    public boolean redeemCheque(Player player, ItemStack chequeItem) {
        Player issuerPlayer;
        if (!this.isCheque(chequeItem)) {
            player.sendMessage("\u00a7c\ud83d\udcb0 This is not a valid cheque!");
            return false;
        }
        ItemMeta meta = chequeItem.getItemMeta();
        if (meta == null) {
            return false;
        }
        String chequeId = (String)meta.getPersistentDataContainer().get(this.CHEQUE_ID_KEY, PersistentDataType.STRING);
        Double amount = (Double)meta.getPersistentDataContainer().get(this.CHEQUE_AMOUNT_KEY, PersistentDataType.DOUBLE);
        String issuer = (String)meta.getPersistentDataContainer().get(this.CHEQUE_ISSUER_KEY, PersistentDataType.STRING);
        String signature = (String)meta.getPersistentDataContainer().get(this.CHEQUE_SIGNATURE_KEY, PersistentDataType.STRING);
        if (chequeId == null || amount == null || signature == null) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Invalid cheque data!");
            return false;
        }
        CurrencyData data = this.issuedCheques.get(chequeId);
        if (data == null) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Cheque not found or already redeemed!");
            return false;
        }
        if (data.isRedeemed()) {
            player.sendMessage("\u00a7c\ud83d\udcb0 This cheque has already been redeemed!");
            return false;
        }
        String expectedSignature = this.generateSignature(chequeId, amount, data.getIssuer().toString());
        if (!signature.equals(expectedSignature)) {
            player.sendMessage("\u00a7c\ud83d\udcb0 Invalid cheque signature! Possible forgery detected!");
            Logger.warn("Possible cheque forgery attempt by " + player.getName() + " with cheque " + chequeId);
            return false;
        }
        this.plugin.getEconomyManager().getEconomy().depositPlayer((OfflinePlayer)player, amount.doubleValue());
        data.setRedeemed(true);
        data.setRedeemedBy(player.getUniqueId());
        data.setRedeemedAt(LocalDateTime.now());
        chequeItem.setAmount(0);
        player.sendMessage("\u00a7a\ud83d\udcb0 Successfully redeemed cheque for $" + String.format("%.2f", amount) + "!");
        player.sendMessage("\u00a7e\ud83d\udcc4 Cheque ID: \u00a7f" + chequeId.substring(0, 8) + "...");
        if (!player.getUniqueId().equals(data.getIssuer()) && (issuerPlayer = this.plugin.getServer().getPlayer(data.getIssuer())) != null && issuerPlayer.isOnline()) {
            issuerPlayer.sendMessage("\u00a7b\ud83d\udcb0 Your cheque for $" + String.format("%.2f", amount) + " was redeemed by " + player.getName() + "!");
        }
        Logger.info("Player " + player.getName() + " redeemed cheque " + chequeId + " for $" + amount);
        return true;
    }

    public boolean canUseAsPayment(ItemStack cheque, double requiredAmount) {
        if (!this.isCheque(cheque)) {
            return false;
        }
        double chequeAmount = this.getChequeAmount(cheque);
        return Math.abs(chequeAmount - requiredAmount) < 0.01;
    }

    public double getTradeValue(ItemStack cheque) {
        return this.getChequeAmount(cheque);
    }

    private ItemStack createChequeItem(String chequeId, double amount, Player issuer, String signature) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm");
        ItemStack cheque = new ItemBuilder(Material.PAPER).setName("\u00a76\u00a7l\ud83d\udcb0 BANK CHEQUE \u00a76\u00a7l\ud83d\udcb0").setLore(Arrays.asList("\u00a77\u25b8 \u00a7fAmount: \u00a7a$" + String.format("%.2f", amount), "\u00a77\u25b8 \u00a7fIssued by: \u00a7e" + issuer.getName(), "\u00a77\u25b8 \u00a7fIssue Date: \u00a77" + now.format(formatter), "\u00a77\u25b8 \u00a7fCheque ID: \u00a78" + chequeId.substring(0, 12) + "...", "", "\u00a76\u00a7l\ud83d\udcb1 TRADING COMPATIBLE:", "\u00a77\u25b8 \u00a7fShopkeeper Plugin: \u00a7a\u2713 SUPPORTED", "\u00a77\u25b8 \u00a7fTrade Value: \u00a7a$" + String.format("%.2f", amount), "\u00a77\u25b8 \u00a7fUniversal Currency: \u00a7a\u2713 ACCEPTED", "", "\u00a76\u00a7l\u26a1 SECURITY FEATURES:", "\u00a77\u25b8 \u00a7fDigital Signature: \u00a7a\u2713 VERIFIED", "\u00a77\u25b8 \u00a7fAnti-Forgery Protection: \u00a7a\u2713 ACTIVE", "\u00a77\u25b8 \u00a7fBlockchain Secured: \u00a7a\u2713 PROTECTED", "", "\u00a7e\u00a7l\ud83d\udca1 HOW TO USE:", "\u00a77\u25b8 \u00a7fRight-click to redeem this cheque", "\u00a77\u25b8 \u00a7fUse in trading with other players", "\u00a77\u25b8 \u00a7fWorks with Shopkeeper plugin", "\u00a77\u25b8 \u00a7fOne-time use only", "", "\u00a7c\u00a7l\u26a0 WARNING:", "\u00a77\u25b8 \u00a7cDo not lose this cheque!", "\u00a77\u25b8 \u00a7cTreat like real money!", "", "\u00a78\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "\u00a78\u00a7oEasyShopGUI Bank \u2022 Secure Digital Currency", "\u00a78\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501")).addGlow().build();
        ItemMeta meta = cheque.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.CHEQUE_ID_KEY, PersistentDataType.STRING, (Object)chequeId);
            meta.getPersistentDataContainer().set(this.CHEQUE_AMOUNT_KEY, PersistentDataType.DOUBLE, (Object)amount);
            meta.getPersistentDataContainer().set(this.CHEQUE_ISSUER_KEY, PersistentDataType.STRING, (Object)issuer.getUniqueId().toString());
            meta.getPersistentDataContainer().set(this.CHEQUE_TIMESTAMP_KEY, PersistentDataType.LONG, (Object)System.currentTimeMillis());
            meta.getPersistentDataContainer().set(this.CHEQUE_SIGNATURE_KEY, PersistentDataType.STRING, (Object)signature);
            cheque.setItemMeta(meta);
        }
        return cheque;
    }

    public boolean isChequeWithAmount(ItemStack item, double requiredAmount) {
        if (!this.isCheque(item)) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        Double chequeAmount = (Double)meta.getPersistentDataContainer().get(this.CHEQUE_AMOUNT_KEY, PersistentDataType.DOUBLE);
        return chequeAmount != null && Math.abs(chequeAmount - requiredAmount) < 0.01;
    }

    public double getChequeAmount(ItemStack item) {
        if (!this.isCheque(item)) {
            return 0.0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0.0;
        }
        Double amount = (Double)meta.getPersistentDataContainer().get(this.CHEQUE_AMOUNT_KEY, PersistentDataType.DOUBLE);
        return amount != null ? amount : 0.0;
    }

    public boolean isCheque(ItemStack item) {
        if (item == null || item.getType() != Material.PAPER) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.CHEQUE_ID_KEY, PersistentDataType.STRING);
    }

    private String generateSecureChequeId() {
        StringBuilder id = new StringBuilder();
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        id.append(Long.toHexString(System.currentTimeMillis()).toUpperCase());
        id.append("-");
        for (int i = 0; i < 16; ++i) {
            id.append(chars.charAt(this.random.nextInt(chars.length())));
        }
        return id.toString();
    }

    private String generateSignature(String chequeId, double amount, String issuer) {
        String data = chequeId + amount + issuer + "EASYSHOPGUI_SECRET_KEY";
        return Integer.toHexString(data.hashCode()).toUpperCase();
    }

    private static class CurrencyData {
        private final String id;
        private final double amount;
        private final UUID issuer;
        private final LocalDateTime issuedAt;
        private final String signature;
        private boolean redeemed;
        private UUID redeemedBy;
        private LocalDateTime redeemedAt;

        public CurrencyData(String id, double amount, UUID issuer, LocalDateTime issuedAt, String signature, boolean redeemed) {
            this.id = id;
            this.amount = amount;
            this.issuer = issuer;
            this.issuedAt = issuedAt;
            this.signature = signature;
            this.redeemed = redeemed;
        }

        public String getId() {
            return this.id;
        }

        public double getAmount() {
            return this.amount;
        }

        public UUID getIssuer() {
            return this.issuer;
        }

        public LocalDateTime getIssuedAt() {
            return this.issuedAt;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isRedeemed() {
            return this.redeemed;
        }

        public void setRedeemed(boolean redeemed) {
            this.redeemed = redeemed;
        }

        public UUID getRedeemedBy() {
            return this.redeemedBy;
        }

        public void setRedeemedBy(UUID redeemedBy) {
            this.redeemedBy = redeemedBy;
        }

        public LocalDateTime getRedeemedAt() {
            return this.redeemedAt;
        }

        public void setRedeemedAt(LocalDateTime redeemedAt) {
            this.redeemedAt = redeemedAt;
        }
    }
}

