/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.data.ShopDataLoader;
import dev.turjo.easyshopgui.gui.ItemDetailGui;
import dev.turjo.easyshopgui.gui.QuickSellGui;
import dev.turjo.easyshopgui.gui.SearchGui;
import dev.turjo.easyshopgui.gui.SectionGui;
import dev.turjo.easyshopgui.gui.ShopGui;
import dev.turjo.easyshopgui.gui.TransactionHistoryGui;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.models.ShopSection;
import dev.turjo.easyshopgui.utils.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class GuiManager {
    private final EasyShopGUI plugin;
    private Map<String, ShopSection> sections;
    private final Map<Player, QuickSellGui> activeQuickSellGuis = new ConcurrentHashMap<Player, QuickSellGui>();
    private final Map<Player, SearchGui> activeSearchGuis = new ConcurrentHashMap<Player, SearchGui>();
    private final Map<Player, TransactionHistoryGui> activeTransactionGuis = new ConcurrentHashMap<Player, TransactionHistoryGui>();

    public GuiManager(EasyShopGUI plugin) {
        this.plugin = plugin;
        this.sections = new HashMap<String, ShopSection>();
        Logger.debug("GuiManager initialized");
        this.loadSections();
    }

    private void loadSections() {
        ShopDataLoader loader = new ShopDataLoader(this.plugin);
        this.sections = loader.loadSections();
        Logger.info("GuiManager loaded " + this.sections.size() + " sections");
        this.sections.keySet().forEach(key -> Logger.debug("Available section: " + key));
    }

    public void reloadSections() {
        this.loadSections();
        Logger.info("Sections reloaded");
    }

    public void openShop(Player player, String shopName) {
        ShopGui shopGui = new ShopGui(this.plugin, player, shopName);
        Logger.debug("Opening shop for player: " + player.getName());
        shopGui.open();
    }

    public void openSection(Player player, String sectionId) {
        ShopSection section = this.sections.get(sectionId);
        Logger.debug("Attempting to open section: " + sectionId + " for player: " + player.getName());
        if (section != null) {
            Logger.debug("Section found with " + section.getItems().size() + " items");
            SectionGui sectionGui = new SectionGui(this.plugin, player, section);
            sectionGui.open();
        } else {
            player.sendMessage("\u00a7cSection not found: " + sectionId + ". Available sections: " + String.join((CharSequence)", ", this.sections.keySet()));
        }
    }

    public void openItemDetail(Player player, String sectionId, String itemId) {
        ShopSection section = this.sections.get(sectionId);
        if (section != null) {
            ShopItem shopItem = section.getItem(itemId);
            if (shopItem != null) {
                ItemDetailGui itemGui = new ItemDetailGui(this.plugin, player, shopItem);
                itemGui.open();
            } else {
                player.sendMessage("\u00a7cItem not found: " + itemId);
            }
        } else {
            player.sendMessage("\u00a7cSection not found: " + sectionId);
        }
    }

    public Map<String, ShopSection> getSections() {
        return this.sections;
    }

    public Map<Player, QuickSellGui> getActiveQuickSellGuis() {
        return this.activeQuickSellGuis;
    }

    public Map<Player, SearchGui> getActiveSearchGuis() {
        return this.activeSearchGuis;
    }

    public Map<Player, TransactionHistoryGui> getActiveTransactionGuis() {
        return this.activeTransactionGuis;
    }
}

