/*
 * Decompiled with CFR 0.152.
 */
package dev.turjo.easyshopgui.gui;

import dev.turjo.easyshopgui.EasyShopGUI;
import dev.turjo.easyshopgui.models.ShopItem;
import dev.turjo.easyshopgui.utils.ItemBuilder;
import dev.turjo.easyshopgui.utils.MessageUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemDetailGui {
    private final EasyShopGUI plugin;
    private final Player player;
    private final ShopItem shopItem;
    private int quantity = 1;

    public ItemDetailGui(EasyShopGUI plugin, Player player, ShopItem shopItem) {
        this.plugin = plugin;
        this.player = player;
        this.shopItem = shopItem;
    }

    public void open() {
        Inventory gui = Bukkit.createInventory(null, (int)45, (String)MessageUtils.colorize("&6&l\u2726 " + this.shopItem.getDisplayName() + " &6&l\u2726"));
        this.fillBackground(gui);
        this.addMainItem(gui);
        this.addQuantityControls(gui);
        this.addActionButtons(gui);
        this.addPlayerInfo(gui);
        this.addNavigation(gui);
        this.player.openInventory(gui);
    }

    private void fillBackground(Inventory gui) {
        int[] borderSlots;
        ItemStack background = new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE).setName(" ").build();
        ItemStack border = new ItemBuilder(Material.CYAN_STAINED_GLASS_PANE).setName(" ").build();
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, background);
        }
        for (int slot : borderSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44}) {
            gui.setItem(slot, border);
        }
    }

    private void addMainItem(Inventory gui) {
        double totalBuyPrice = this.shopItem.getBuyPrice() * (double)this.quantity;
        double totalSellPrice = this.shopItem.getSellPrice() * (double)this.quantity;
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        ItemStack displayItem = new ItemBuilder(this.shopItem.getMaterial()).setName("&6&l\u2b50 " + this.shopItem.getDisplayName() + " &6&l\u2b50").setLore(Arrays.asList("&7\u25b8 &fItem Description:", "&7  " + this.shopItem.getDescription(), "", "&7\u25b8 &fCurrent Quantity: &e" + this.quantity, "&7\u25b8 &fMax Stack Size: &e" + this.shopItem.getMaterial().getMaxStackSize(), "", "&7\u25b8 &fPricing Information:", "&a  Buy Price (Each): &f$" + String.format("%.2f", this.shopItem.getBuyPrice()), "&a  Buy Price (Total): &f$" + String.format("%.2f", totalBuyPrice), "&c  Sell Price (Each): &f$" + String.format("%.2f", this.shopItem.getSellPrice()), "&c  Sell Price (Total): &f$" + String.format("%.2f", totalSellPrice), "", "&7\u25b8 &fStock Information:", "&e  Available Stock: " + (String)(this.shopItem.getStock() == -1 ? "&aUnlimited" : "&e" + this.shopItem.getStock()), "&e  Market Demand: " + this.getDemandColor(this.shopItem.getDemand()) + this.shopItem.getDemand().toUpperCase(), "", "&7\u25b8 &fYour Balance: " + (balance >= totalBuyPrice ? "&a" : "&c") + "$" + String.format("%.2f", balance), "&7\u25b8 &fCan Afford: " + (balance >= totalBuyPrice ? "&a\u2713 YES" : "&c\u2717 NO"))).setAmount(Math.min(this.quantity, 64)).addGlow().build();
        gui.setItem(13, displayItem);
    }

    private void addQuantityControls(Inventory gui) {
        gui.setItem(10, new ItemBuilder(Material.RED_CONCRETE).setName("&c&l-5 &e&lQUANTITY").setLore(Arrays.asList("&7\u25b8 &fDecrease by 5", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&c&l\u27a4 &cClick to decrease!")).build());
        gui.setItem(11, new ItemBuilder(Material.ORANGE_CONCRETE).setName("&c&l-1 &e&lQUANTITY").setLore(Arrays.asList("&7\u25b8 &fDecrease by 1", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&c&l\u27a4 &cClick to decrease!")).build());
        gui.setItem(12, new ItemBuilder(Material.YELLOW_CONCRETE).setName("&e&l\ud83d\udcca &e&lCURRENT QUANTITY").setLore(Arrays.asList("&7\u25b8 &fSelected Amount: &e" + this.quantity, "&7\u25b8 &fMax Possible: &e" + this.shopItem.getMaterial().getMaxStackSize(), "&7\u25b8 &fTotal Weight: &e" + this.quantity * 1 + " units", "", "&e&l\u26a1 &eAdjust with buttons!")).setAmount(Math.min(this.quantity, 64)).build());
        gui.setItem(14, new ItemBuilder(Material.LIME_CONCRETE).setName("&a&l+1 &e&lQUANTITY").setLore(Arrays.asList("&7\u25b8 &fIncrease by 1", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&a&l\u27a4 &aClick to increase!")).build());
        gui.setItem(15, new ItemBuilder(Material.GREEN_CONCRETE).setName("&a&l+5 &e&lQUANTITY").setLore(Arrays.asList("&7\u25b8 &fIncrease by 5", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&a&l\u27a4 &aClick to increase!")).build());
        gui.setItem(19, new ItemBuilder(Material.IRON_INGOT).setName("&7&l\u26a1 &e&lSET TO 16").setLore(Arrays.asList("&7\u25b8 &fQuick set to 16", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&a&l\u27a4 &aClick to set!")).setAmount(16).build());
        gui.setItem(20, new ItemBuilder(Material.GOLD_INGOT).setName("&6&l\u26a1 &e&lSET TO 32").setLore(Arrays.asList("&7\u25b8 &fQuick set to 32", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&a&l\u27a4 &aClick to set!")).setAmount(32).build());
        gui.setItem(21, new ItemBuilder(Material.DIAMOND).setName("&b&l\u26a1 &e&lSET TO 64").setLore(Arrays.asList("&7\u25b8 &fQuick set to 64", "&7\u25b8 &fCurrent: &e" + this.quantity, "", "&a&l\u27a4 &aClick to set!")).setAmount(64).build());
    }

    private void addActionButtons(Inventory gui) {
        double totalBuyPrice = this.shopItem.getBuyPrice() * (double)this.quantity;
        double totalSellPrice = this.shopItem.getSellPrice() * (double)this.quantity;
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        boolean canAfford = balance >= totalBuyPrice;
        gui.setItem(30, new ItemBuilder(canAfford ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK).setName(canAfford ? "&a&l\ud83d\udcb0 &e&lBUY ITEMS" : "&c&l\u274c &e&lCANNOT AFFORD").setLore(Arrays.asList("&7\u25b8 &fQuantity: &e" + this.quantity, "&7\u25b8 &fTotal Cost: &a$" + String.format("%.2f", totalBuyPrice), "&7\u25b8 &fYour Balance: " + (canAfford ? "&a" : "&c") + "$" + String.format("%.2f", balance), "&7\u25b8 &fAfter Purchase: &e$" + String.format("%.2f", balance - totalBuyPrice), "", canAfford ? "&a&l\u27a4 &aClick to purchase!" : "&c&l\u27a4 &cInsufficient funds!")).addGlow(canAfford).build());
        int playerItemCount = this.getPlayerItemCount();
        boolean canSell = playerItemCount >= this.quantity;
        gui.setItem(32, new ItemBuilder(canSell ? Material.GOLD_BLOCK : Material.COAL_BLOCK).setName(canSell ? "&6&l\ud83d\udcb8 &e&lSELL ITEMS" : "&c&l\u274c &e&lNOT ENOUGH ITEMS").setLore(Arrays.asList("&7\u25b8 &fQuantity: &e" + this.quantity, "&7\u25b8 &fTotal Earn: &6$" + String.format("%.2f", totalSellPrice), "&7\u25b8 &fYou Have: " + (canSell ? "&a" : "&c") + playerItemCount, "&7\u25b8 &fAfter Sale: &e$" + String.format("%.2f", balance + totalSellPrice), "", canSell ? "&6&l\u27a4 &6Click to sell!" : "&c&l\u27a4 &cNot enough items!")).addGlow(canSell).build());
        gui.setItem(31, new ItemBuilder(Material.NETHER_STAR).setName("&d&l\u26a1 &e&lQUICK ACTIONS").setLore(Arrays.asList("&7\u25b8 &fAvailable actions:", "&d  \u2022 &fBuy Max Affordable", "&d  \u2022 &fSell All Inventory", "&d  \u2022 &fAdd to Wishlist", "&d  \u2022 &fSet Price Alert", "", "&d&l\u27a4 &dClick for options!")).addGlow().build());
    }

    private void addPlayerInfo(Inventory gui) {
        double balance = this.plugin.getEconomyManager().getEconomy().getBalance((OfflinePlayer)this.player);
        gui.setItem(4, new ItemBuilder(Material.PLAYER_HEAD).setName("&6&l\ud83d\udc64 &e&l" + this.player.getName().toUpperCase()).setLore(Arrays.asList("&7\u25b8 &fBalance: &a$" + String.format("%.2f", balance), "&7\u25b8 &fSelected Item: &e" + this.shopItem.getDisplayName(), "&7\u25b8 &fQuantity: &e" + this.quantity, "", "&7\u25b8 &fDiscount: &a" + this.getPlayerDiscount() + "%", "&7\u25b8 &fSell Multiplier: &a" + this.getSellMultiplier() + "x", "&7\u25b8 &fVIP Status: " + (this.player.hasPermission("easyshopgui.vip") ? "&aActive" : "&7Inactive"))).setSkullOwner(this.player.getName()).build());
    }

    private void addNavigation(Inventory gui) {
        gui.setItem(36, new ItemBuilder(Material.ARROW).setName("&c&l\u2190 &e&lBACK").setLore(Arrays.asList("&7\u25b8 &fReturn to section", "", "&c&l\u27a4 &cClick to go back!")).build());
        gui.setItem(44, new ItemBuilder(Material.BARRIER).setName("&c&l\u2716 &e&lCLOSE").setLore(Arrays.asList("&7\u25b8 &fClose this menu", "", "&c&l\u27a4 &cClick to close!")).build());
    }

    private String getDemandColor(String demand) {
        switch (demand.toLowerCase()) {
            case "high": {
                return "&c";
            }
            case "medium": {
                return "&e";
            }
            case "low": {
                return "&a";
            }
        }
        return "&7";
    }

    private int getPlayerItemCount() {
        int count = 0;
        for (ItemStack item : this.player.getInventory().getContents()) {
            if (item == null || item.getType() != this.shopItem.getMaterial()) continue;
            count += item.getAmount();
        }
        return count;
    }

    private int getPlayerDiscount() {
        if (this.player.hasPermission("easyshopgui.discount.vip")) {
            return 15;
        }
        if (this.player.hasPermission("easyshopgui.discount.premium")) {
            return 10;
        }
        if (this.player.hasPermission("easyshopgui.discount.member")) {
            return 5;
        }
        return 0;
    }

    private double getSellMultiplier() {
        if (this.player.hasPermission("easyshopgui.multiplier.vip")) {
            return 1.5;
        }
        if (this.player.hasPermission("easyshopgui.multiplier.premium")) {
            return 1.3;
        }
        if (this.player.hasPermission("easyshopgui.multiplier.member")) {
            return 1.1;
        }
        return 1.0;
    }

    public void increaseQuantity(int amount) {
        this.quantity = Math.min(this.quantity + amount, 64);
        this.open();
    }

    public void decreaseQuantity(int amount) {
        this.quantity = Math.max(this.quantity - amount, 1);
        this.open();
    }

    public void setQuantity(int amount) {
        this.quantity = Math.max(1, Math.min(amount, 64));
        this.open();
    }
}

